/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar;

import java.nio.ByteBuffer;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.columnar.BINARY$;
import org.apache.spark.sql.columnar.BOOLEAN$;
import org.apache.spark.sql.columnar.BYTE$;
import org.apache.spark.sql.columnar.ColumnType;
import org.apache.spark.sql.columnar.ColumnType$;
import org.apache.spark.sql.columnar.ColumnTypeSuite$;
import org.apache.spark.sql.columnar.ColumnTypeSuite$$anonfun$testColumnType$1$;
import org.apache.spark.sql.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.columnar.CustomClass;
import org.apache.spark.sql.columnar.DATE$;
import org.apache.spark.sql.columnar.DOUBLE$;
import org.apache.spark.sql.columnar.FIXED_DECIMAL;
import org.apache.spark.sql.columnar.FLOAT$;
import org.apache.spark.sql.columnar.GENERIC;
import org.apache.spark.sql.columnar.INT$;
import org.apache.spark.sql.columnar.LONG$;
import org.apache.spark.sql.columnar.NativeColumnType;
import org.apache.spark.sql.columnar.SHORT$;
import org.apache.spark.sql.columnar.STRING$;
import org.apache.spark.sql.columnar.TIMESTAMP$;
import org.apache.spark.sql.execution.SparkSqlSerializer;
import org.apache.spark.sql.execution.SparkSqlSerializer$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u00015\u0011qbQ8mk6tG+\u001f9f'VLG/\u001a\u0006\u0003\u0007\u0011\t\u0001bY8mk6t\u0017M\u001d\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011qbE\u0005\u0003)\u0019\u0011q\u0001T8hO&tw\rC\u0003\u0017\u0001\u0011\u0005q#\u0001\u0004=S:LGO\u0010\u000b\u00021A\u0011\u0011\u0004A\u0007\u0002\u0005!91\u0004\u0001b\u0001\n\u0013a\u0012a\u0005#F\r\u0006+F\nV0C+\u001a3UIU0T\u0013j+U#A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\u0007%sG\u000f\u0003\u0004%\u0001\u0001\u0006I!H\u0001\u0015\t\u00163\u0015)\u0016'U?\n+fIR#S?NK%,\u0012\u0011\t\u000f\u0019\u0002!\u0019!C\u0005O\u0005YQ*\u0011)`\u000f\u0016sUIU%D+\u0005A\u0003CA\r*\u0013\tQ#AA\u0004H\u000b:+%+S\"\t\r1\u0002\u0001\u0015!\u0003)\u00031i\u0015\tU0H\u000b:+%+S\"!\u0011\u0015q\u0003\u0001\"\u00010\u0003Q!Xm\u001d;OCRLg/Z\"pYVlg\u000eV=qKV\u0011\u0001'\u0012\u000b\u0003ca#2AM\u001bT!\tq2'\u0003\u00025?\t!QK\\5u\u0011\u00151T\u00061\u00018\u0003\u0019\u0001X\u000f\u001e;feB)a\u0004\u000f\u001eCe%\u0011\u0011h\b\u0002\n\rVt7\r^5p]J\u0002\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\u00079LwNC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$A\u0003\"zi\u0016\u0014UO\u001a4feB\u00111)\u0015\t\u0003\t\u0016c\u0001\u0001B\u0003G[\t\u0007qIA\u0001U#\tA5\n\u0005\u0002\u001f\u0013&\u0011!j\b\u0002\b\u001d>$\b.\u001b8h!\tau*D\u0001N\u0015\tqE!A\u0003usB,7/\u0003\u0002Q\u001b\nQ\u0011\t^8nS\u000e$\u0016\u0010]3\n\u0005I{%\u0001D%oi\u0016\u0014h.\u00197UsB,\u0007\"\u0002+.\u0001\u0004)\u0016AB4fiR,'\u000f\u0005\u0003\u001f-j\u0012\u0015BA, \u0005%1UO\\2uS>t\u0017\u0007C\u0003Z[\u0001\u0007!,\u0001\u0006d_2,XN\u001c+za\u0016\u00042!G.D\u0013\ta&A\u0001\tOCRLg/Z\"pYVlg\u000eV=qK\")a\f\u0001C\u0001?\u0006qA/Z:u\u0007>dW/\u001c8UsB,WC\u00011g)\u0011\u0011\u0014\r\u001c8\t\u000bek\u0006\u0019\u00012\u0011\u0007e\u0019W-\u0003\u0002e\u0005\tQ1i\u001c7v[:$\u0016\u0010]3\u0011\u0005\u00113G!B4^\u0005\u0004A'a\u0002&w[RK\b/Z\t\u0003\u0011&\u0004\"A\b6\n\u0005-|\"aA!os\")a'\u0018a\u0001[B)a\u0004\u000f\u001efe!)A+\u0018a\u0001_B!aD\u0016\u001ef\u0011\u0015\t\b\u0001\"\u0003s\u0003\u001dAW\r\u001f#v[B$\"a\u001d>\u0011\u0005Q<hB\u0001\u0010v\u0013\t1x$\u0001\u0004Qe\u0016$WMZ\u0005\u0003qf\u0014aa\u0015;sS:<'B\u0001< \u0011\u0015Y\b\u000f1\u0001j\u0003\u00151\u0018\r\\;f\u0011\u0015i\b\u0001\"\u0003\u007f\u0003)!W/\u001c9Ck\u001a4WM\u001d\u000b\u0003S~Da!!\u0001}\u0001\u0004Q\u0014\u0001\u00022vM\u001a\u0004")
public class ColumnTypeSuite
extends SparkFunSuite {
    private final int DEFAULT_BUFFER_SIZE;
    private final GENERIC org$apache$spark$sql$columnar$ColumnTypeSuite$$MAP_GENERIC = new GENERIC((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$));

    private int DEFAULT_BUFFER_SIZE() {
        return this.DEFAULT_BUFFER_SIZE;
    }

    public GENERIC org$apache$spark$sql$columnar$ColumnTypeSuite$$MAP_GENERIC() {
        return this.org$apache$spark$sql$columnar$ColumnTypeSuite$$MAP_GENERIC;
    }

    public <T extends AtomicType> void testNativeColumnType(NativeColumnType<T> columnType, Function2<ByteBuffer, Object, BoxedUnit> putter, Function1<ByteBuffer, Object> getter) {
        this.testColumnType((ColumnType)columnType, (Function2)putter, (Function1)getter);
    }

    public <JvmType> void testColumnType(ColumnType<JvmType> columnType, Function2<ByteBuffer, JvmType, BoxedUnit> putter, Function1<ByteBuffer, JvmType> getter) {
        ByteBuffer buffer = ByteBuffer.allocate(this.DEFAULT_BUFFER_SIZE());
        IndexedSeq seq = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this, columnType){
            public static final long serialVersionUID = 0L;
            private final ColumnType columnType$1;

            public final JvmType apply(int x$25) {
                return ColumnarTestUtils$.MODULE$.makeRandomValue(this.columnType$1);
            }
            {
                this.columnType$1 = columnType$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".extract"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnType})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnType, putter, buffer, seq){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnTypeSuite $outer;
            public final ColumnType columnType$1;
            public final Function2 putter$1;
            public final ByteBuffer buffer$1;
            private final IndexedSeq seq$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.buffer$1.rewind();
                this.seq$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnType$1 $outer;

                    public final void apply(JvmType x$26) {
                        this.$outer.putter$1.apply((Object)this.$outer.buffer$1, x$26);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.buffer$1.rewind();
                this.seq$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnType$1 $outer;

                    public final void apply(JvmType expected2) {
                        this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, expected2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testColumnType$1$$anonfun$apply$mcV$sp$5 $outer;
                            private final Object expected$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"buffer = ").append((Object)this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$anonfun$$$outer().buffer$1).append((Object)", expected = ").append(this.expected$1).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.expected$1 = expected$1;
                            }
                        });
                        Object extracted = this.$outer.columnType$1.extract(this.$outer.buffer$1);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer().convertToEqualizer(expected2);
                        Object $org_scalatest_assert_macro_right = extracted;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"Extracted value didn't equal to the original one. ").append((Object)this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer().org$apache$spark$sql$columnar$ColumnTypeSuite$$hexDump(expected2)).append((Object)" != ").append((Object)this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer().org$apache$spark$sql$columnar$ColumnTypeSuite$$hexDump(extracted)).append((Object)", buffer = ").append(this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer().org$apache$spark$sql$columnar$ColumnTypeSuite$$dumpBuffer((ByteBuffer)this.$outer.buffer$1.duplicate().rewind())).toString());
                    }

                    public /* synthetic */ $anonfun$testColumnType$1 org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ColumnTypeSuite org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnType$1 = columnType$1;
                this.putter$1 = putter$1;
                this.buffer$1 = buffer$1;
                this.seq$1 = seq$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".append"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnType})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnType, getter, buffer, seq){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnTypeSuite $outer;
            public final ColumnType columnType$1;
            public final Function1 getter$1;
            public final ByteBuffer buffer$1;
            private final IndexedSeq seq$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.buffer$1.rewind();
                this.seq$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnType$2 $outer;

                    public final void apply(JvmType x$27) {
                        this.$outer.columnType$1.append(x$27, this.$outer.buffer$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.buffer$1.rewind();
                this.seq$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnType$2 $outer;

                    public final void apply(JvmType expected2) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer().convertToEqualizer(expected2);
                        Object $org_scalatest_assert_macro_right = this.$outer.getter$1.apply((Object)this.$outer.buffer$1);
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Extracted value didn't equal to the original one");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ColumnTypeSuite org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnType$1 = columnType$1;
                this.getter$1 = getter$1;
                this.buffer$1 = buffer$1;
                this.seq$1 = seq$1;
            }
        });
    }

    public String org$apache$spark$sql$columnar$ColumnTypeSuite$$hexDump(Object value) {
        return ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(value.toString())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(char ch) {
                return Integer.toHexString(ch & 0xFFFF);
            }
        }, Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString(" ");
    }

    public Object org$apache$spark$sql$columnar$ColumnTypeSuite$$dumpBuffer(ByteBuffer buff) {
        StringBuilder sb = new StringBuilder();
        while (buff.hasRemaining()) {
            byte b = buff.get();
            sb.append(Integer.toHexString(b & 0xFF)).append(' ');
        }
        if (sb.nonEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public ColumnTypeSuite() {
        this.DEFAULT_BUFFER_SIZE = 512;
        this.test("defaultSize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map checks = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BOOLEAN$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BYTE$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SHORT$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)INT$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)DATE$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)LONG$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)TIMESTAMP$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)FLOAT$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)DOUBLE$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)STRING$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BINARY$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new FIXED_DECIMAL(15, 10)), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$MAP_GENERIC()), (Object)BoxesRunTime.boxToInteger((int)16))}));
                checks.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(Tuple2<ColumnType<? super byte[]>, Object> x0$1) {
                        Tuple2<ColumnType<? super byte[]>, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            ColumnType columnType = (ColumnType)tuple2._1();
                            int expectedSize = tuple2._2$mcI$sp();
                            this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)expectedSize), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong defaultSize for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnType})), BoxesRunTime.boxToInteger((int)columnType.defaultSize()));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ColumnTypeSuite org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("actualSize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.checkActualSize$1((ColumnType)BOOLEAN$.MODULE$, BoxesRunTime.boxToBoolean((boolean)true), 1);
                this.checkActualSize$1((ColumnType)BYTE$.MODULE$, BoxesRunTime.boxToByte((byte)127), 1);
                this.checkActualSize$1((ColumnType)SHORT$.MODULE$, BoxesRunTime.boxToShort((short)Short.MAX_VALUE), 2);
                this.checkActualSize$1((ColumnType)INT$.MODULE$, BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), 4);
                this.checkActualSize$1((ColumnType)DATE$.MODULE$, BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), 4);
                this.checkActualSize$1((ColumnType)LONG$.MODULE$, BoxesRunTime.boxToLong((long)Long.MAX_VALUE), 8);
                this.checkActualSize$1((ColumnType)TIMESTAMP$.MODULE$, BoxesRunTime.boxToLong((long)Long.MAX_VALUE), 8);
                this.checkActualSize$1((ColumnType)FLOAT$.MODULE$, BoxesRunTime.boxToFloat((float)Float.MAX_VALUE), 4);
                this.checkActualSize$1((ColumnType)DOUBLE$.MODULE$, BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), 8);
                this.checkActualSize$1((ColumnType)STRING$.MODULE$, UTF8String.fromString((String)"hello"), 4 + "hello".getBytes("utf-8").length);
                this.checkActualSize$1((ColumnType)BINARY$.MODULE$, Array$.MODULE$.fill(4, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte apply() {
                        return this.apply$mcB$sp();
                    }

                    public byte apply$mcB$sp() {
                        return (byte)0;
                    }
                }, ClassTag$.MODULE$.Byte()), 8);
                this.checkActualSize$1((ColumnType)new FIXED_DECIMAL(15, 10), Decimal$.MODULE$.apply(0L, 15, 10), 8);
                Map generic = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a")}));
                this.checkActualSize$1((ColumnType)this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$MAP_GENERIC(), SparkSqlSerializer$.MODULE$.serialize((Object)generic, ClassTag$.MODULE$.apply(Map.class)), 12);
            }

            private final void checkActualSize$1(ColumnType columnType, Object value, int expected2) {
                Integer n = BoxesRunTime.boxToInteger((int)expected2);
                String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong actualSize for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnType}));
                GenericMutableRow row = new GenericMutableRow(1);
                columnType.setField((MutableRow)row, 0, value);
                this.$outer.assertResult(n, string, BoxesRunTime.boxToInteger((int)columnType.actualSize((InternalRow)row, 0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.testNativeColumnType((NativeColumnType)BOOLEAN$.MODULE$, (Function2<ByteBuffer, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ByteBuffer buffer, boolean v) {
                buffer.put((byte)(v ? 1 : 0));
            }
        }, (Function1<ByteBuffer, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ByteBuffer buffer) {
                return buffer.get() == 1;
            }
        });
        this.testNativeColumnType((NativeColumnType)BYTE$.MODULE$, (Function2<ByteBuffer, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ByteBuffer x$1, byte x$2) {
                x$1.put(x$2);
            }
        }, (Function1<ByteBuffer, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply(ByteBuffer x$3) {
                return x$3.get();
            }
        });
        this.testNativeColumnType((NativeColumnType)SHORT$.MODULE$, (Function2<ByteBuffer, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ByteBuffer x$4, short x$5) {
                x$4.putShort(x$5);
            }
        }, (Function1<ByteBuffer, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply(ByteBuffer x$6) {
                return x$6.getShort();
            }
        });
        this.testNativeColumnType((NativeColumnType)INT$.MODULE$, (Function2<ByteBuffer, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ByteBuffer x$7, int x$8) {
                x$7.putInt(x$8);
            }
        }, (Function1<ByteBuffer, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ByteBuffer x$9) {
                return x$9.getInt();
            }
        });
        this.testNativeColumnType((NativeColumnType)DATE$.MODULE$, (Function2<ByteBuffer, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ByteBuffer x$10, int x$11) {
                x$10.putInt(x$11);
            }
        }, (Function1<ByteBuffer, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ByteBuffer x$12) {
                return x$12.getInt();
            }
        });
        this.testNativeColumnType((NativeColumnType)LONG$.MODULE$, (Function2<ByteBuffer, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ByteBuffer x$13, long x$14) {
                x$13.putLong(x$14);
            }
        }, (Function1<ByteBuffer, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(ByteBuffer x$15) {
                return x$15.getLong();
            }
        });
        this.testNativeColumnType((NativeColumnType)TIMESTAMP$.MODULE$, (Function2<ByteBuffer, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ByteBuffer x$16, long x$17) {
                x$16.putLong(x$17);
            }
        }, (Function1<ByteBuffer, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(ByteBuffer x$18) {
                return x$18.getLong();
            }
        });
        this.testNativeColumnType((NativeColumnType)FLOAT$.MODULE$, (Function2<ByteBuffer, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ByteBuffer x$19, float x$20) {
                x$19.putFloat(x$20);
            }
        }, (Function1<ByteBuffer, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final float apply(ByteBuffer x$21) {
                return x$21.getFloat();
            }
        });
        this.testNativeColumnType((NativeColumnType)DOUBLE$.MODULE$, (Function2<ByteBuffer, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ByteBuffer x$22, double x$23) {
                x$22.putDouble(x$23);
            }
        }, (Function1<ByteBuffer, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(ByteBuffer x$24) {
                return x$24.getDouble();
            }
        });
        this.testNativeColumnType((NativeColumnType)new FIXED_DECIMAL(15, 10), (Function2<ByteBuffer, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ByteBuffer buffer, Decimal decimal) {
                buffer.putLong(decimal.toUnscaledLong());
            }
        }, (Function1<ByteBuffer, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Decimal apply(ByteBuffer buffer) {
                return Decimal$.MODULE$.apply(buffer.getLong(), 15, 10);
            }
        });
        this.testNativeColumnType((NativeColumnType)STRING$.MODULE$, (Function2<ByteBuffer, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ByteBuffer buffer, UTF8String string) {
                byte[] bytes = string.getBytes();
                buffer.putInt(bytes.length);
                buffer.put(bytes);
            }
        }, (Function1<ByteBuffer, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UTF8String apply(ByteBuffer buffer) {
                int length = buffer.getInt();
                byte[] bytes = new byte[length];
                buffer.get(bytes);
                return UTF8String.fromBytes((byte[])bytes);
            }
        });
        this.testColumnType((ColumnType)BINARY$.MODULE$, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ByteBuffer buffer, byte[] bytes) {
                buffer.putInt(bytes.length).put(bytes);
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final byte[] apply(ByteBuffer buffer) {
                void var3_3;
                int length = buffer.getInt();
                byte[] bytes = new byte[length];
                buffer.get(bytes, 0, length);
                return var3_3;
            }
        });
        this.test("GENERIC", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer buffer = ByteBuffer.allocate(512);
                Map obj = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"spark"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"sql")}));
                byte[] serializedObj = SparkSqlSerializer$.MODULE$.serialize((Object)obj, ClassTag$.MODULE$.apply(Map.class));
                this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$MAP_GENERIC().append(SparkSqlSerializer$.MODULE$.serialize((Object)obj, ClassTag$.MODULE$.apply(Map.class)), buffer);
                buffer.rewind();
                int length = buffer.getInt();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)length));
                int $org_scalatest_assert_macro_right = serializedObj.length;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                byte[] bytes = new byte[length];
                buffer.get(bytes, 0, length);
                this.$outer.assertResult(obj, "Deserialized object didn't equal to the original object", SparkSqlSerializer$.MODULE$.deserialize(bytes, ClassTag$.MODULE$.Nothing()));
                buffer.rewind();
                buffer.putInt(serializedObj.length).put(serializedObj);
                buffer.rewind();
                this.$outer.assertResult(obj, "Deserialized object didn't equal to the original object", SparkSqlSerializer$.MODULE$.deserialize(this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$MAP_GENERIC().extract(buffer), ClassTag$.MODULE$.Nothing()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CUSTOM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf conf = new SparkConf();
                conf.set("spark.kryo.registrator", "org.apache.spark.sql.columnar.Registrator");
                SerializerInstance serializer = new SparkSqlSerializer(conf).newInstance();
                ByteBuffer buffer = ByteBuffer.allocate(512);
                CustomClass obj = new CustomClass(Integer.MAX_VALUE, Long.MAX_VALUE);
                byte[] serializedObj = serializer.serialize((Object)obj, ClassTag$.MODULE$.apply(CustomClass.class)).array();
                this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$MAP_GENERIC().append(serializer.serialize((Object)obj, ClassTag$.MODULE$.apply(CustomClass.class)).array(), buffer);
                buffer.rewind();
                int length = buffer.getInt();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)length));
                int $org_scalatest_assert_macro_right = serializedObj.length;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                int $org_scalatest_assert_macro_left2 = 13;
                int $org_scalatest_assert_macro_right2 = length;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                byte[] genericSerializedObj = SparkSqlSerializer$.MODULE$.serialize((Object)obj, ClassTag$.MODULE$.apply(CustomClass.class));
                int $org_scalatest_assert_macro_left3 = length;
                int $org_scalatest_assert_macro_right3 = genericSerializedObj.length;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 != $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                int $org_scalatest_assert_macro_left4 = length;
                int $org_scalatest_assert_macro_right4 = genericSerializedObj.length;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                byte[] bytes = new byte[length];
                buffer.get(bytes, 0, length);
                this.$outer.assertResult(obj, "Custom deserialized object didn't equal the original object", serializer.deserialize(ByteBuffer.wrap(bytes), ClassTag$.MODULE$.Nothing()));
                buffer.rewind();
                buffer.putInt(serializedObj.length).put(serializedObj);
                buffer.rewind();
                this.$outer.assertResult(obj, "Custom deserialized object didn't equal the original object", serializer.deserialize(ByteBuffer.wrap(this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$MAP_GENERIC().extract(buffer)), ClassTag$.MODULE$.Nothing()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("column type for decimal types with different precision", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 18).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.$outer.org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer().assertResult(new FIXED_DECIMAL(i, 0), ColumnType$.MODULE$.apply((DataType)new DecimalType(i, 0)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.assertResult(new GENERIC((DataType)new DecimalType(19, 0)), ColumnType$.MODULE$.apply((DataType)new DecimalType(19, 0)));
            }

            public /* synthetic */ ColumnTypeSuite org$apache$spark$sql$columnar$ColumnTypeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

