/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.columnar.BINARY$;
import org.apache.spark.sql.columnar.BOOLEAN$;
import org.apache.spark.sql.columnar.BYTE$;
import org.apache.spark.sql.columnar.ColumnType;
import org.apache.spark.sql.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.columnar.DATE$;
import org.apache.spark.sql.columnar.DOUBLE$;
import org.apache.spark.sql.columnar.FIXED_DECIMAL;
import org.apache.spark.sql.columnar.FLOAT$;
import org.apache.spark.sql.columnar.GENERIC;
import org.apache.spark.sql.columnar.INT$;
import org.apache.spark.sql.columnar.LONG$;
import org.apache.spark.sql.columnar.NullableColumnBuilderSuite$;
import org.apache.spark.sql.columnar.SHORT$;
import org.apache.spark.sql.columnar.STRING$;
import org.apache.spark.sql.columnar.TIMESTAMP$;
import org.apache.spark.sql.columnar.TestNullableColumnBuilder;
import org.apache.spark.sql.columnar.TestNullableColumnBuilder$;
import org.apache.spark.sql.execution.SparkSqlSerializer$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001E2A!\u0001\u0002\u0001\u001b\tQb*\u001e7mC\ndWmQ8mk6t')^5mI\u0016\u00148+^5uK*\u00111\u0001B\u0001\tG>dW/\u001c8be*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fAi\u0011AB\u0005\u0003#\u0019\u0011Qb\u00159be.4UO\\*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003e!Xm\u001d;Ok2d\u0017M\u00197f\u0007>dW/\u001c8Ck&dG-\u001a:\u0016\u0005iACCA\u000e\"!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0011)f.\u001b;\t\u000b\t:\u0002\u0019A\u0012\u0002\u0015\r|G.^7o)f\u0004X\rE\u0002\u0017I\u0019J!!\n\u0002\u0003\u0015\r{G.^7o)f\u0004X\r\u0005\u0002(Q1\u0001A!B\u0015\u0018\u0005\u0004Q#a\u0002&w[RK\b/Z\t\u0003W9\u0002\"\u0001\b\u0017\n\u00055j\"a\u0002(pi\"Lgn\u001a\t\u00039=J!\u0001M\u000f\u0003\u0007\u0005s\u0017\u0010")
public class NullableColumnBuilderSuite
extends SparkFunSuite {
    public <JvmType> void testNullableColumnBuilder(ColumnType<JvmType> columnType) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column builder: empty column"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NullableColumnBuilderSuite $outer;
            private final ColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TestNullableColumnBuilder<JvmType> columnBuilder = TestNullableColumnBuilder$.MODULE$.apply(this.columnType$1, TestNullableColumnBuilder$.MODULE$.apply$default$2());
                ByteBuffer buffer = columnBuilder.build();
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)this.columnType$1.typeId()), "Wrong column type ID", BoxesRunTime.boxToInteger((int)buffer.getInt()));
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)0), "Wrong null count", BoxesRunTime.boxToInteger((int)buffer.getInt()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(buffer.hasRemaining(), "buffer.hasRemaining()"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnType$1 = columnType$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column builder: buffer size auto growth"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NullableColumnBuilderSuite $outer;
            private final ColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TestNullableColumnBuilder<JvmType> columnBuilder = TestNullableColumnBuilder$.MODULE$.apply(this.columnType$1, TestNullableColumnBuilder$.MODULE$.apply$default$2());
                InternalRow randomRow = ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)this.columnType$1, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)new Serializable(this, columnBuilder, randomRow){
                    public static final long serialVersionUID = 0L;
                    private final TestNullableColumnBuilder columnBuilder$1;
                    private final InternalRow randomRow$1;

                    public final void apply(int x$2) {
                        this.apply$mcVI$sp(x$2);
                    }

                    public void apply$mcVI$sp(int x$2) {
                        this.columnBuilder$1.appendFrom(this.randomRow$1, 0);
                    }
                    {
                        this.columnBuilder$1 = columnBuilder$1;
                        this.randomRow$1 = randomRow$1;
                    }
                });
                ByteBuffer buffer = columnBuilder.build();
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)this.columnType$1.typeId()), "Wrong column type ID", BoxesRunTime.boxToInteger((int)buffer.getInt()));
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)0), "Wrong null count", BoxesRunTime.boxToInteger((int)buffer.getInt()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnType$1 = columnType$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column builder: null values"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NullableColumnBuilderSuite $outer;
            public final ColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TestNullableColumnBuilder<JvmType> columnBuilder = TestNullableColumnBuilder$.MODULE$.apply(this.columnType$1, TestNullableColumnBuilder$.MODULE$.apply$default$2());
                InternalRow randomRow = ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)this.columnType$1, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
                GenericMutableRow nullRow = ColumnarTestUtils$.MODULE$.makeNullRow(1);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)new Serializable(this, columnBuilder, randomRow, nullRow){
                    public static final long serialVersionUID = 0L;
                    private final TestNullableColumnBuilder columnBuilder$2;
                    private final InternalRow randomRow$2;
                    private final GenericMutableRow nullRow$1;

                    public final void apply(int x$3) {
                        this.apply$mcVI$sp(x$3);
                    }

                    public void apply$mcVI$sp(int x$3) {
                        this.columnBuilder$2.appendFrom(this.randomRow$2, 0);
                        this.columnBuilder$2.appendFrom((InternalRow)this.nullRow$1, 0);
                    }
                    {
                        this.columnBuilder$2 = columnBuilder$2;
                        this.randomRow$2 = randomRow$2;
                        this.nullRow$1 = nullRow$1;
                    }
                });
                ByteBuffer buffer = columnBuilder.build();
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)this.columnType$1.typeId()), "Wrong column type ID", BoxesRunTime.boxToInteger((int)buffer.getInt()));
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)4), "Wrong null count", BoxesRunTime.boxToInteger((int)buffer.getInt()));
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 7).by(2).foreach$mVc$sp((Function1)new Serializable(this, buffer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testNullableColumnBuilder$3 $outer;
                    private final ByteBuffer buffer$1;

                    public final void apply(int x$4) {
                        this.apply$mcVI$sp(x$4);
                    }

                    public void apply$mcVI$sp(int x$4) {
                        this.$outer.org$apache$spark$sql$columnar$NullableColumnBuilderSuite$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)x$4), "Wrong null position", BoxesRunTime.boxToInteger((int)this.buffer$1.getInt()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.buffer$1 = buffer$1;
                    }
                });
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)new Serializable(this, randomRow, buffer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testNullableColumnBuilder$3 $outer;
                    private final InternalRow randomRow$2;
                    private final ByteBuffer buffer$1;

                    public final void apply(int x$5) {
                        this.apply$mcVI$sp(x$5);
                    }

                    public void apply$mcVI$sp(int x$5) {
                        Object actual = this.$outer.columnType$1 instanceof GENERIC ? SparkSqlSerializer$.MODULE$.deserialize((byte[])this.$outer.columnType$1.extract(this.buffer$1), ClassTag$.MODULE$.Any()) : this.$outer.columnType$1.extract(this.buffer$1);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$columnar$NullableColumnBuilderSuite$$anonfun$$$outer().convertToEqualizer(actual);
                        Object $org_scalatest_assert_macro_right = this.randomRow$2.get(0, this.$outer.columnType$1.dataType());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$columnar$NullableColumnBuilderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Extracted value didn't equal to the original one");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.randomRow$2 = randomRow$2;
                        this.buffer$1 = buffer$1;
                    }
                });
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(buffer.hasRemaining(), "buffer.hasRemaining()"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ NullableColumnBuilderSuite org$apache$spark$sql$columnar$NullableColumnBuilderSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnType$1 = columnType$1;
            }
        });
    }

    public NullableColumnBuilderSuite() {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[]{BOOLEAN$.MODULE$, BYTE$.MODULE$, SHORT$.MODULE$, INT$.MODULE$, DATE$.MODULE$, LONG$.MODULE$, TIMESTAMP$.MODULE$, FLOAT$.MODULE$, DOUBLE$.MODULE$, STRING$.MODULE$, BINARY$.MODULE$, new FIXED_DECIMAL(15, 10), new GENERIC((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$))}))).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NullableColumnBuilderSuite $outer;

            public final void apply(ColumnType<? super byte[]> x$1) {
                this.$outer.testNullableColumnBuilder(x$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

