/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.columnar.BOOLEAN$;
import org.apache.spark.sql.columnar.ColumnStats;
import org.apache.spark.sql.columnar.ColumnType;
import org.apache.spark.sql.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.columnar.NativeColumnType;
import org.apache.spark.sql.columnar.NoopColumnStats;
import org.apache.spark.sql.columnar.compression.BooleanBitSet$;
import org.apache.spark.sql.columnar.compression.CompressionScheme;
import org.apache.spark.sql.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.columnar.compression.Decoder;
import org.apache.spark.sql.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.columnar.compression.TestCompressibleColumnBuilder$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u001d2A!\u0001\u0002\u0001\u001f\t\u0011\"i\\8mK\u0006t')\u001b;TKR\u001cV/\u001b;f\u0015\t\u0019A!A\u0006d_6\u0004(/Z:tS>t'BA\u0003\u0007\u0003!\u0019w\u000e\\;n]\u0006\u0014(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAQA\u0007\u0001\u0005\u0002m\t\u0001b]6fY\u0016$xN\u001c\u000b\u00039\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011A!\u00168ji\")1%\u0007a\u0001I\u0005)1m\\;oiB\u0011Q$J\u0005\u0003My\u00111!\u00138u\u0001")
public class BooleanBitSetSuite
extends SparkFunSuite {
    public void skeleton(int count) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply((ColumnStats)new NoopColumnStats(), BOOLEAN$.MODULE$, (CompressionScheme)BooleanBitSet$.MODULE$);
        Seq rows = (Seq)Seq$.MODULE$.fill(count, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalRow apply() {
                return ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)BOOLEAN$.MODULE$, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
            }
        });
        Seq values = (Seq)rows.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InternalRow x$1) {
                return x$1.getBoolean(0);
            }
        }, Seq$.MODULE$.canBuildFrom());
        rows.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final TestCompressibleColumnBuilder builder$1;

            public final void apply(InternalRow x$2) {
                this.builder$1.appendFrom(x$2, 0);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        int extra = count % BooleanBitSet$.MODULE$.BITS_PER_LONG() == 0 ? 0 : 1;
        int compressedSize = 8 + (count / BooleanBitSet$.MODULE$.BITS_PER_LONG() + extra) * 8;
        this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()));
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)BooleanBitSet$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()));
        this.assertResult(BoxesRunTime.boxToInteger((int)count), "Wrong element count", BoxesRunTime.boxToInteger((int)buffer.getInt()));
        long temp1 = 0L;
        LongRef word = new LongRef(temp1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)new Serializable(this, values, buffer, word){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;
            private final Seq values$1;
            private final ByteBuffer buffer$1;
            private final LongRef word$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int bit = i % BooleanBitSet$.MODULE$.BITS_PER_LONG();
                this.word$1.elem = bit == 0 ? this.buffer$1.getLong() : this.word$1.elem;
                this.$outer.assertResult(this.values$1.apply(i), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong value in compressed buffer, index=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), BoxesRunTime.boxToBoolean(((this.word$1.elem & 1L << bit) != 0L ? 1 : 0) != 0));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.values$1 = values$1;
                this.buffer$1 = buffer$1;
                this.word$1 = word$1;
            }
        });
        buffer.rewind().position(headerSize + 4);
        Decoder decoder = BooleanBitSet$.MODULE$.decoder(buffer, (NativeColumnType)BOOLEAN$.MODULE$);
        GenericMutableRow mutableRow = new GenericMutableRow(1);
        if (values.nonEmpty()) {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext");
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            values.foreach((Function1)new Serializable(this, decoder, mutableRow){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BooleanBitSetSuite $outer;
                private final Decoder decoder$1;
                private final GenericMutableRow mutableRow$1;

                public final void apply(boolean x$3) {
                    Boolean bl = BoxesRunTime.boxToBoolean((boolean)x$3);
                    this.decoder$1.next((MutableRow)this.mutableRow$1, 0);
                    this.$outer.assertResult(bl, "Wrong decoded value", BoxesRunTime.boxToBoolean((boolean)this.mutableRow$1.getBoolean(0)));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.decoder$1 = decoder$1;
                    this.mutableRow$1 = mutableRow$1;
                }
            });
        }
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext"));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public BooleanBitSetSuite() {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(0);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": less than 1 word"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG() - 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": exactly 1 word"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": multiple whole words"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG() * 2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": multiple words and 1 more bit"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG() * 2 + 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

