/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.spark.HashPartitioner;
import org.apache.spark.InternalAccumulator$;
import org.apache.spark.LocalSparkContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContextImpl;
import org.apache.spark.TaskContextImpl$;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.ClosableByteArrayInputStream;
import org.apache.spark.sql.execution.ShuffledRowRDD;
import org.apache.spark.sql.execution.UnsafeRowSerializer;
import org.apache.spark.sql.execution.UnsafeRowSerializerSuite$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.collection.ExternalSorter;
import org.apache.spark.util.collection.ExternalSorter$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestData;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001\u001b\tARK\\:bM\u0016\u0014vn^*fe&\fG.\u001b>feN+\u0018\u000e^3\u000b\u0005\r!\u0011!C3yK\u000e,H/[8o\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0005\t\u0003\u001fAi\u0011AB\u0005\u0003#\u0019\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\b\u0014\u0013\t!bAA\tM_\u000e\fGn\u00159be.\u001cuN\u001c;fqRDQA\u0006\u0001\u0005\u0002]\ta\u0001P5oSRtD#\u0001\r\u0011\u0005e\u0001Q\"\u0001\u0002\t\u000bm\u0001A\u0011\u0002\u000f\u0002\u0017Q|WK\\:bM\u0016\u0014vn\u001e\u000b\u0004;\u0015Z\u0003C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\t\"\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005\u0011z\"!C+og\u00064WMU8x\u0011\u00151#\u00041\u0001(\u0003\r\u0011xn\u001e\t\u0003Q%j\u0011\u0001B\u0005\u0003U\u0011\u00111AU8x\u0011\u0015a#\u00041\u0001.\u0003\u0019\u00198\r[3nCB\u0019a&M\u001a\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012Q!\u0011:sCf\u0004\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0003\u0002\u000bQL\b/Z:\n\u0005a*$\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000bi\u0002A\u0011B\u001e\u0002%Ut7/\u00194f%><8i\u001c8wKJ$XM\u001d\u000b\u0003y}\u0002BAL\u001f(;%\u0011ah\f\u0002\n\rVt7\r^5p]FBQ\u0001L\u001dA\u00025\u0002")
public class UnsafeRowSerializerSuite
extends SparkFunSuite
implements LocalSparkContext {
    private transient SparkContext sc;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public void org$apache$spark$LocalSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    public void org$apache$spark$LocalSparkContext$$super$afterEach() {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
    }

    public void beforeAll() {
        LocalSparkContext.class.beforeAll((LocalSparkContext)this);
    }

    public void afterEach() {
        LocalSparkContext.class.afterEach((LocalSparkContext)this);
    }

    public void resetSparkContext() {
        LocalSparkContext.class.resetSparkContext((LocalSparkContext)this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this);
    }

    public void beforeEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void beforeEach(TestData testData) {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public void afterEach(ConfigMap configMap) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (ConfigMap)configMap);
    }

    public void afterEach(TestData testData) {
        BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this, (TestData)testData);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public UnsafeRow org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$toUnsafeRow(Row row, DataType[] schema) {
        Function1<Row, UnsafeRow> converter = this.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$unsafeRowConverter(schema);
        return (UnsafeRow)converter.apply((Object)row);
    }

    public Function1<Row, UnsafeRow> org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$unsafeRowConverter(DataType[] schema) {
        UnsafeProjection converter = UnsafeProjection$.MODULE$.create(schema);
        return new Serializable(this, converter){
            public static final long serialVersionUID = 0L;
            private final UnsafeProjection converter$1;

            public final UnsafeRow apply(Row row) {
                return this.converter$1.apply((InternalRow)CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)row));
            }
            {
                this.converter$1 = converter$1;
            }
        };
    }

    public UnsafeRowSerializerSuite() {
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        LocalSparkContext.class.$init$((LocalSparkContext)this);
        this.test("toUnsafeRow() test helper method", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeRowSerializerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", BoxesRunTime.boxToInteger((int)123)}));
                UnsafeRow unsafeRow = this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$toUnsafeRow(row, (DataType[])((Object[])new DataType[]{StringType$.MODULE$, IntegerType$.MODULE$}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(row.getString(0));
                String $org_scalatest_assert_macro_right = unsafeRow.getUTF8String(0).toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)row.getInt(1)));
                int $org_scalatest_assert_macro_right2 = unsafeRow.getInt(1);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("basic row serialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeRowSerializerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq rows = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"World", BoxesRunTime.boxToInteger((int)2)}))}));
                Seq unsafeRows = (Seq)rows.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final UnsafeRow apply(Row row) {
                        return this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer().org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$toUnsafeRow(row, (DataType[])((Object[])new DataType[]{StringType$.MODULE$, IntegerType$.MODULE$}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                SerializerInstance serializer = new UnsafeRowSerializer(2).newInstance();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                SerializationStream serializerStream = serializer.serializeStream((OutputStream)baos);
                unsafeRows.foreach((Function1)new Serializable(this, serializerStream){
                    public static final long serialVersionUID = 0L;
                    private final SerializationStream serializerStream$1;

                    public final SerializationStream apply(UnsafeRow unsafeRow) {
                        this.serializerStream$1.writeKey((Object)BoxesRunTime.boxToInteger((int)0), ClassTag$.MODULE$.Int());
                        return this.serializerStream$1.writeValue((Object)unsafeRow, ClassTag$.MODULE$.apply(UnsafeRow.class));
                    }
                    {
                        this.serializerStream$1 = serializerStream$1;
                    }
                });
                serializerStream.close();
                ClosableByteArrayInputStream input = new ClosableByteArrayInputStream(baos.toByteArray());
                Iterator deserializerIter = serializer.deserializeStream((InputStream)input).asKeyValueIterator();
                unsafeRows.foreach((Function1)new Serializable(this, deserializerIter){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final Iterator deserializerIter$1;

                    public final void apply(UnsafeRow expectedRow) {
                        UnsafeRow actualRow = (UnsafeRow)((Tuple2)this.deserializerIter$1.next())._2();
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)expectedRow.getSizeInBytes()));
                        int $org_scalatest_assert_macro_right = actualRow.getSizeInBytes();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer().convertToEqualizer(expectedRow.getString(0));
                        String $org_scalatest_assert_macro_right2 = actualRow.getString(0);
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)expectedRow.getInt(1)));
                        int $org_scalatest_assert_macro_right3 = actualRow.getInt(1);
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.deserializerIter$1 = deserializerIter$1;
                    }
                });
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(deserializerIter.hasNext(), "deserializerIter.hasNext"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(input.closed(), "input.closed");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            public /* synthetic */ UnsafeRowSerializerSuite org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("close empty input stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeRowSerializerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ClosableByteArrayInputStream input = new ClosableByteArrayInputStream((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
                SerializerInstance serializer = new UnsafeRowSerializer(2).newInstance();
                Iterator deserializerIter = serializer.deserializeStream((InputStream)input).asKeyValueIterator();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(deserializerIter.hasNext(), "deserializerIter.hasNext"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(input.closed(), "input.closed");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-10466: external sorter spilling with unsafe row serializer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeRowSerializerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ObjectRef sc = new ObjectRef(null);
                ObjectRef outputFile = new ObjectRef(null);
                SparkEnv oldEnv = SparkEnv$.MODULE$.get();
                Utils$.MODULE$.tryWithSafeFinally((Function0)new Serializable(this, sc, outputFile){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final ObjectRef sc$1;
                    private final ObjectRef outputFile$1;

                    public final long[] apply() {
                        SparkConf conf = new SparkConf().set("spark.shuffle.spill.initialMemoryThreshold", "1024").set("spark.shuffle.sort.bypassMergeThreshold", "0").set("spark.shuffle.memoryFraction", "0.0001");
                        this.sc$1.elem = new SparkContext("local", "test", conf);
                        this.outputFile$1.elem = File.createTempFile("test-unsafe-row-serializer-spill", "");
                        Function1<Row, UnsafeRow> converter = this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer().org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$unsafeRowConverter((DataType[])((Object[])new DataType[]{IntegerType$.MODULE$}));
                        Iterator data = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000).iterator().map((Function1)new Serializable(this, converter){
                            public static final long serialVersionUID = 0L;
                            private final Function1 converter$2;

                            public final Tuple2<Object, UnsafeRow> apply(int i) {
                                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), this.converter$2.apply((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))));
                            }
                            {
                                this.converter$2 = converter$2;
                            }
                        });
                        Some x$1 = new Some((Object)new HashPartitioner(10));
                        Some x$2 = new Some((Object)new UnsafeRowSerializer(1));
                        None$ x$3 = ExternalSorter$.MODULE$.$lessinit$greater$default$1();
                        None$ x$4 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                        ExternalSorter sorter = new ExternalSorter((Option)x$3, (Option)x$1, (Option)x$4, (Option)x$2);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)sorter.numSpills()));
                        int $org_scalatest_assert_macro_right = 0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        sorter.insertAll(data);
                        int $org_scalatest_assert_macro_left2 = sorter.numSpills();
                        int $org_scalatest_assert_macro_right2 = 0;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2);
                        this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        TaskContextImpl taskContext = new TaskContextImpl(0, 0, 0L, 0, null, null, InternalAccumulator$.MODULE$.create((SparkContext)this.sc$1.elem), TaskContextImpl$.MODULE$.$lessinit$greater$default$8(), TaskContextImpl$.MODULE$.$lessinit$greater$default$9());
                        taskContext.taskMetrics().shuffleWriteMetrics_$eq((Option)new Some((Object)new ShuffleWriteMetrics()));
                        return sorter.writePartitionedFile((BlockId)new ShuffleBlockId(0, 0, 0), (TaskContext)taskContext, (File)this.outputFile$1.elem);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.sc$1 = sc$1;
                        this.outputFile$1 = outputFile$1;
                    }
                }, (Function0)new Serializable(this, sc, outputFile, oldEnv){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef sc$1;
                    private final ObjectRef outputFile$1;
                    private final SparkEnv oldEnv$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        if ((SparkContext)this.sc$1.elem != null) {
                            ((SparkContext)this.sc$1.elem).stop();
                        }
                        SparkEnv$.MODULE$.set(this.oldEnv$1);
                        if ((File)this.outputFile$1.elem != null) {
                            ((File)this.outputFile$1.elem).delete();
                        }
                    }
                    {
                        this.sc$1 = sc$1;
                        this.outputFile$1 = outputFile$1;
                        this.oldEnv$1 = oldEnv$1;
                    }
                });
            }

            public /* synthetic */ UnsafeRowSerializerSuite org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-10403: unsafe row serializer with UnsafeShuffleManager", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeRowSerializerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkConf conf = new SparkConf().set("spark.shuffle.manager", "tungsten-sort");
                this.$outer.sc_$eq(new SparkContext("local", "test", conf));
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello", BoxesRunTime.boxToInteger((int)123)}));
                UnsafeRow unsafeRow = this.$outer.org$apache$spark$sql$execution$UnsafeRowSerializerSuite$$toUnsafeRow(row, (DataType[])((Object[])new DataType[]{StringType$.MODULE$, IntegerType$.MODULE$}));
                SparkContext qual$1 = this.$outer.sc();
                Seq x$5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)unsafeRow), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)unsafeRow), new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)unsafeRow)}));
                int x$6 = qual$1.parallelize$default$2();
                RDD rowsRDD = qual$1.parallelize(x$5, x$6, ClassTag$.MODULE$.apply(Tuple2.class));
                ShuffledRowRDD shuffled = new ShuffledRowRDD(rowsRDD, (Serializer)new UnsafeRowSerializer(2), 2);
                shuffled.count();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

