/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.test.TestSQLContext;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class JavaDataFrameSuite {
    private transient JavaSparkContext jsc;
    private transient TestSQLContext context;
    private static Comparator<Row> CrosstabRowComparator = new Comparator<Row>(){

        @Override
        public int compare(Row row1, Row row2) {
            String item1 = row1.getString(0);
            String item2 = row2.getString(0);
            return item1.compareTo(item2);
        }
    };

    @Before
    public void setUp() {
        SparkContext sc = new SparkContext("local[*]", "testing");
        this.jsc = new JavaSparkContext(sc);
        this.context = new TestSQLContext(sc);
        this.context.loadTestData();
    }

    @After
    public void tearDown() {
        this.context.sparkContext().stop();
        this.context = null;
        this.jsc = null;
    }

    @Test
    public void testExecution() {
        DataFrame df2 = this.context.table("testData").filter("key = 1");
        Assert.assertEquals((Object)df2.select("key", new String[0]).collect()[0].get(0), (Object)1);
    }

    @Test
    public void testVarargMethods() {
        DataFrame df2 = this.context.table("testData");
        df2.toDF(new String[]{"key1", "value1"});
        df2.select("key", new String[]{"value"});
        df2.select(new Column[]{functions.col((String)"key"), functions.col((String)"value")});
        df2.selectExpr(new String[]{"key", "value + 1"});
        df2.sort("key", new String[]{"value"});
        df2.sort(new Column[]{functions.col((String)"key"), functions.col((String)"value")});
        df2.orderBy("key", new String[]{"value"});
        df2.orderBy(new Column[]{functions.col((String)"key"), functions.col((String)"value")});
        df2.groupBy("key", new String[]{"value"}).agg(functions.col((String)"key"), new Column[]{functions.col((String)"value"), functions.sum((String)"value")});
        df2.groupBy(new Column[]{functions.col((String)"key"), functions.col((String)"value")}).agg(functions.col((String)"key"), new Column[]{functions.col((String)"value"), functions.sum((String)"value")});
        df2.agg(functions.first((String)"key"), new Column[]{functions.sum((String)"value")});
        df2.groupBy(new Column[0]).avg(new String[]{"key"});
        df2.groupBy(new Column[0]).mean(new String[]{"key"});
        df2.groupBy(new Column[0]).max(new String[]{"key"});
        df2.groupBy(new Column[0]).min(new String[]{"key"});
        df2.groupBy(new Column[0]).sum(new String[]{"key"});
        df2.groupBy(new Column[0]).agg(functions.countDistinct((String)"key", (String[])new String[]{"value"}), new Column[0]);
        df2.groupBy(new Column[0]).agg(functions.countDistinct((Column)functions.col((String)"key"), (Column[])new Column[]{functions.col((String)"value")}), new Column[0]);
        df2.select(new Column[]{functions.coalesce((Column[])new Column[]{functions.col((String)"key")})});
        DataFrame df22 = this.context.table("testData2");
        df22.select(new Column[]{functions.exp((String)"a"), functions.exp((String)"b")});
        df22.select(new Column[]{functions.exp((Column)functions.log((String)"a"))});
        df22.select(new Column[]{functions.pow((String)"a", (String)"a"), functions.pow((String)"b", (double)2.0)});
        df22.select(new Column[]{functions.pow((Column)functions.col((String)"a"), (Column)functions.col((String)"b")), functions.exp((String)"b")});
        df22.select(new Column[]{functions.sin((String)"a"), functions.acos((String)"b")});
        df22.select(new Column[]{functions.rand(), functions.acos((String)"b")});
        df22.select(new Column[]{functions.col((String)"*"), functions.randn((long)5L)});
    }

    @Ignore
    public void testShow() {
        DataFrame df2 = this.context.table("testData");
        df2.show();
        df2.show(1000);
    }

    @Test
    public void testCreateDataFrameFromJavaBeans() {
        Bean bean = new Bean();
        JavaRDD rdd = this.jsc.parallelize(Arrays.asList(bean));
        DataFrame df2 = this.context.createDataFrame(rdd, Bean.class);
        StructType schema = df2.schema();
        Assert.assertEquals((Object)new StructField("a", (DataType)DoubleType$.MODULE$, false, Metadata.empty()), (Object)schema.apply("a"));
        Assert.assertEquals((Object)new StructField("b", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, Metadata.empty()), (Object)schema.apply("b"));
        ArrayType valueType = new ArrayType(DataTypes.IntegerType, false);
        MapType mapType = new MapType(DataTypes.StringType, (DataType)valueType, true);
        Assert.assertEquals((Object)new StructField("c", (DataType)mapType, true, Metadata.empty()), (Object)schema.apply("c"));
        Assert.assertEquals((Object)new StructField("d", (DataType)new ArrayType(DataTypes.StringType, true), true, Metadata.empty()), (Object)schema.apply("d"));
        Row first = df2.select("a", new String[]{"b", "c", "d"}).first();
        Assert.assertEquals((double)bean.getA(), (double)first.getDouble(0), (double)0.0);
        Seq result = (Seq)first.getAs(1);
        Assert.assertEquals((long)bean.getB().length, (long)result.length());
        for (int i = 0; i < result.length(); ++i) {
            Assert.assertEquals((Object)bean.getB()[i], (Object)result.apply(i));
        }
        Seq outputBuffer = (Seq)first.getJavaMap(2).get("hello");
        Assert.assertArrayEquals((int[])bean.getC().get("hello"), (int[])Ints.toArray((Collection)JavaConversions.seqAsJavaList((Seq)outputBuffer)));
        Seq d = (Seq)first.getAs(3);
        Assert.assertEquals((long)bean.getD().size(), (long)d.length());
        for (int i = 0; i < d.length(); ++i) {
            Assert.assertEquals((Object)bean.getD().get(i), (Object)d.apply(i));
        }
    }

    @Test
    public void testCrosstab() {
        DataFrame df2 = this.context.table("testData2");
        DataFrame crosstab = df2.stat().crosstab("a", "b");
        String[] columnNames = crosstab.schema().fieldNames();
        Assert.assertEquals((Object)columnNames[0], (Object)"a_b");
        Assert.assertEquals((Object)columnNames[1], (Object)"1");
        Assert.assertEquals((Object)columnNames[2], (Object)"2");
        Row[] rows = crosstab.collect();
        Arrays.sort(rows, CrosstabRowComparator);
        Integer count = 1;
        for (Row row : rows) {
            Assert.assertEquals((Object)row.get(0).toString(), (Object)count.toString());
            Assert.assertEquals((long)row.getLong(1), (long)1L);
            Assert.assertEquals((long)row.getLong(2), (long)1L);
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
    }

    @Test
    public void testFrequentItems() {
        DataFrame df2 = this.context.table("testData2");
        String[] cols = new String[]{"a"};
        DataFrame results = df2.stat().freqItems(cols, 0.2);
        Assert.assertTrue((boolean)results.collect()[0].getSeq(0).contains((Object)1));
    }

    @Test
    public void testCorrelation() {
        DataFrame df2 = this.context.table("testData2");
        Double pearsonCorr = df2.stat().corr("a", "b", "pearson");
        Assert.assertTrue((Math.abs(pearsonCorr) < 1.0E-6 ? 1 : 0) != 0);
    }

    @Test
    public void testCovariance() {
        DataFrame df2 = this.context.table("testData2");
        Double result = df2.stat().cov("a", "b");
        Assert.assertTrue((Math.abs(result) < 1.0E-6 ? 1 : 0) != 0);
    }

    @Test
    public void testSampleBy() {
        DataFrame df2 = this.context.range(0L, 100L, 1L, 2).select(new Column[]{functions.col((String)"id").mod((Object)3).as("key")});
        DataFrame sampled = df2.stat().sampleBy("key", (Map)ImmutableMap.of((Object)0, (Object)0.1, (Object)1, (Object)0.2), 0L);
        Object[] actual = sampled.groupBy("key", new String[0]).count().orderBy("key", new String[0]).collect();
        Object[] expected2 = new Row[]{RowFactory.create((Object[])new Object[]{0, 5}), RowFactory.create((Object[])new Object[]{1, 8})};
        Assert.assertArrayEquals((Object[])expected2, (Object[])actual);
    }

    public static class Bean
    implements Serializable {
        private double a = 0.0;
        private Integer[] b = new Integer[]{0, 1};
        private Map<String, int[]> c = ImmutableMap.of((Object)"hello", (Object)new int[]{1, 2});
        private List<String> d = Arrays.asList("floppy", "disk");

        public double getA() {
            return this.a;
        }

        public Integer[] getB() {
            return this.b;
        }

        public Map<String, int[]> getC() {
            return this.c;
        }

        public List<String> getD() {
            return this.d;
        }
    }
}

