/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.api.java.UDF2;
import org.apache.spark.sql.types.DataTypes;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JavaUDFSuite
implements Serializable {
    private transient JavaSparkContext sc;
    private transient SQLContext sqlContext;

    @Before
    public void setUp() {
        SparkContext _sc = new SparkContext("local[*]", "testing");
        this.sqlContext = new SQLContext(_sc);
        this.sc = new JavaSparkContext(_sc);
    }

    @After
    public void tearDown() {
        this.sqlContext.sparkContext().stop();
        this.sqlContext = null;
        this.sc = null;
    }

    @Test
    public void udf1Test() {
        this.sqlContext.udf().register("stringLengthTest", (UDF1)new UDF1<String, Integer>(){

            public Integer call(String str) throws Exception {
                return str.length();
            }
        }, DataTypes.IntegerType);
        Row result = this.sqlContext.sql("SELECT stringLengthTest('test')").head();
        assert (result.getInt(0) == 4);
    }

    @Test
    public void udf2Test() {
        this.sqlContext.udf().register("stringLengthTest", (UDF2)new UDF2<String, String, Integer>(){

            public Integer call(String str1, String str2) throws Exception {
                return str1.length() + str2.length();
            }
        }, DataTypes.IntegerType);
        Row result = this.sqlContext.sql("SELECT stringLengthTest('test', 'test2')").head();
        assert (result.getInt(0) == 9);
    }
}

