/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.sources;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaSaveLoadSuite {
    private transient JavaSparkContext sc;
    private transient SQLContext sqlContext;
    String originalDefaultSource;
    File path;
    DataFrame df;

    private void checkAnswer(DataFrame actual, List<Row> expected2) {
        String errorMessage = QueryTest$.MODULE$.checkAnswer(actual, expected2);
        if (errorMessage != null) {
            Assert.fail((String)errorMessage);
        }
    }

    @Before
    public void setUp() throws IOException {
        SparkContext _sc = new SparkContext("local[*]", "testing");
        this.sqlContext = new SQLContext(_sc);
        this.sc = new JavaSparkContext(_sc);
        this.originalDefaultSource = this.sqlContext.conf().defaultDataSourceName();
        this.path = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"datasource").getCanonicalFile();
        if (this.path.exists()) {
            this.path.delete();
        }
        ArrayList<String> jsonObjects = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            jsonObjects.add("{\"a\":" + i + ", \"b\":\"str" + i + "\"}");
        }
        JavaRDD rdd = this.sc.parallelize(jsonObjects);
        this.df = this.sqlContext.read().json(rdd);
        this.df.registerTempTable("jsonTable");
    }

    @After
    public void tearDown() {
        this.sqlContext.sparkContext().stop();
        this.sqlContext = null;
        this.sc = null;
    }

    @Test
    public void saveAndLoad() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("path", this.path.toString());
        this.df.write().mode(SaveMode.ErrorIfExists).format("json").options(options).save();
        DataFrame loadedDF = this.sqlContext.read().format("json").options(options).load();
        this.checkAnswer(loadedDF, this.df.collectAsList());
    }

    @Test
    public void saveAndLoadWithSchema() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("path", this.path.toString());
        this.df.write().format("json").mode(SaveMode.ErrorIfExists).options(options).save();
        ArrayList<StructField> fields = new ArrayList<StructField>();
        fields.add(DataTypes.createStructField((String)"b", (DataType)DataTypes.StringType, (boolean)true));
        StructType schema = DataTypes.createStructType(fields);
        DataFrame loadedDF = this.sqlContext.read().format("json").schema(schema).options(options).load();
        this.checkAnswer(loadedDF, this.sqlContext.sql("SELECT b FROM jsonTable").collectAsList());
    }
}

