/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.CacheManager$;
import org.apache.spark.sql.CacheManager$$anonfun$invalidateCache$1$;
import org.apache.spark.sql.CachedData;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SchemaRDD;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.columnar.CachedBatch;
import org.apache.spark.sql.columnar.InMemoryRelation;
import org.apache.spark.sql.columnar.InMemoryRelation$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class CacheManager$class {
    public static boolean isCached(SQLContext $this, String tableName) {
        return $this.lookupCachedData($this.table(tableName)).nonEmpty();
    }

    public static void cacheTable(SQLContext $this, String tableName) {
        $this.cacheQuery($this.table(tableName), (Option<String>)new Some((Object)tableName), $this.cacheQuery$default$3());
    }

    public static void uncacheTable(SQLContext $this, String tableName) {
        $this.uncacheQuery($this.table(tableName), $this.uncacheQuery$default$2());
    }

    /*
     * WARNING - void declaration
     */
    private static Object readLock(SQLContext $this, Function0 f) {
        Object object;
        ReentrantReadWriteLock.ReadLock lock = $this.org$apache$spark$sql$CacheManager$$cacheLock().readLock();
        lock.lock();
        try {
            object = f.apply();
            lock.unlock();
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.unlock();
            throw throwable;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static Object writeLock(SQLContext $this, Function0 f) {
        Object object;
        ReentrantReadWriteLock.WriteLock lock = $this.org$apache$spark$sql$CacheManager$$cacheLock().writeLock();
        lock.lock();
        try {
            object = f.apply();
            lock.unlock();
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.unlock();
            throw throwable;
        }
        return object;
    }

    public static void clearCache(SQLContext $this) {
        CacheManager$class.writeLock($this, (Function0)new Serializable($this){
            private final /* synthetic */ SQLContext $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$CacheManager$$cachedData().foreach((Function1)new Serializable(this){

                    public final RDD<CachedBatch> apply(CachedData x$1) {
                        RDD<CachedBatch> qual$1 = x$1.cachedRepresentation().cachedColumnBuffers();
                        boolean x$3 = qual$1.unpersist$default$1();
                        return qual$1.unpersist(x$3);
                    }
                });
                this.$outer.org$apache$spark$sql$CacheManager$$cachedData().clear();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void cacheQuery(SQLContext $this, SchemaRDD query, Option tableName, StorageLevel storageLevel) {
        CacheManager$class.writeLock($this, (Function0)new Serializable($this, query, tableName, storageLevel){
            private final /* synthetic */ SQLContext $outer;
            private final SchemaRDD query$1;
            private final Option tableName$1;
            private final StorageLevel storageLevel$1;

            public final Object apply() {
                BoxedUnit boxedUnit;
                LogicalPlan planToCache = this.query$1.queryExecution().analyzed();
                if (this.$outer.lookupCachedData(planToCache).nonEmpty()) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this){

                        public final String apply() {
                            return "Asked to cache already cached data.";
                        }
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = this.$outer.org$apache$spark$sql$CacheManager$$cachedData().$plus$eq((Object)new CachedData(planToCache, InMemoryRelation$.MODULE$.apply(this.$outer.useCompression(), this.$outer.columnBatchSize(), this.storageLevel$1, this.query$1.queryExecution().executedPlan(), (Option<String>)this.tableName$1)));
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.query$1 = query$1;
                this.tableName$1 = tableName$1;
                this.storageLevel$1 = storageLevel$1;
            }
        });
    }

    public static Option cacheQuery$default$2(SQLContext $this) {
        return None$.MODULE$;
    }

    public static StorageLevel cacheQuery$default$3(SQLContext $this) {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public static void uncacheQuery(SQLContext $this, SchemaRDD query, boolean blocking) {
        CacheManager$class.writeLock($this, (Function0)new Serializable($this, query, blocking){
            private final /* synthetic */ SQLContext $outer;
            public final SchemaRDD query$2;
            private final boolean blocking$1;

            public final CachedData apply() {
                LogicalPlan planToCache = this.query$2.queryExecution().analyzed();
                int dataIndex = this.$outer.org$apache$spark$sql$CacheManager$$cachedData().indexWhere((Function1)new Serializable(this, planToCache){
                    private final LogicalPlan planToCache$1;

                    public final boolean apply(CachedData cd) {
                        return this.planToCache$1.sameResult(cd.plan());
                    }
                    {
                        this.planToCache$1 = planToCache$1;
                    }
                });
                Predef$.MODULE$.require(dataIndex >= 0, (Function0)new Serializable(this){
                    private final /* synthetic */ CacheManager$.anonfun.uncacheQuery.1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " is not cached."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.query$2}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                ((CachedData)this.$outer.org$apache$spark$sql$CacheManager$$cachedData().apply(dataIndex)).cachedRepresentation().cachedColumnBuffers().unpersist(this.blocking$1);
                return (CachedData)this.$outer.org$apache$spark$sql$CacheManager$$cachedData().remove(dataIndex);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.query$2 = query$2;
                this.blocking$1 = blocking$1;
            }
        });
    }

    public static boolean uncacheQuery$default$2(SQLContext $this) {
        return true;
    }

    public static boolean tryUncacheQuery(SQLContext $this, SchemaRDD query, boolean blocking) {
        return BoxesRunTime.unboxToBoolean((Object)CacheManager$class.writeLock($this, (Function0)new Serializable($this, query, blocking){
            private final /* synthetic */ SQLContext $outer;
            private final SchemaRDD query$3;
            private final boolean blocking$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * WARNING - void declaration
             */
            public boolean apply$mcZ$sp() {
                void var3_3;
                Object object;
                boolean found;
                LogicalPlan planToCache = this.query$3.queryExecution().analyzed();
                int dataIndex = this.$outer.org$apache$spark$sql$CacheManager$$cachedData().indexWhere((Function1)new Serializable(this, planToCache){
                    private final LogicalPlan planToCache$2;

                    public final boolean apply(CachedData cd) {
                        return this.planToCache$2.sameResult(cd.plan());
                    }
                    {
                        this.planToCache$2 = planToCache$2;
                    }
                });
                boolean bl = found = dataIndex >= 0;
                if (found) {
                    ((CachedData)this.$outer.org$apache$spark$sql$CacheManager$$cachedData().apply(dataIndex)).cachedRepresentation().cachedColumnBuffers().unpersist(this.blocking$2);
                    object = this.$outer.org$apache$spark$sql$CacheManager$$cachedData().remove(dataIndex);
                } else {
                    object = BoxedUnit.UNIT;
                }
                return (boolean)var3_3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.query$3 = query$3;
                this.blocking$2 = blocking$2;
            }
        }));
    }

    public static boolean tryUncacheQuery$default$2(SQLContext $this) {
        return true;
    }

    public static Option lookupCachedData(SQLContext $this, SchemaRDD query) {
        return (Option)CacheManager$class.readLock($this, (Function0)new Serializable($this, query){
            private final /* synthetic */ SQLContext $outer;
            private final SchemaRDD query$4;

            public final Option<CachedData> apply() {
                return this.$outer.lookupCachedData(this.query$4.queryExecution().analyzed());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.query$4 = query$4;
            }
        });
    }

    public static Option lookupCachedData(SQLContext $this, LogicalPlan plan) {
        return (Option)CacheManager$class.readLock($this, (Function0)new Serializable($this, plan){
            private final /* synthetic */ SQLContext $outer;
            public final LogicalPlan plan$1;

            public final Option<CachedData> apply() {
                return this.$outer.org$apache$spark$sql$CacheManager$$cachedData().find((Function1)new Serializable(this){
                    private final /* synthetic */ CacheManager$.anonfun.lookupCachedData.2 $outer;

                    public final boolean apply(CachedData cd) {
                        return this.$outer.plan$1.sameResult(cd.plan());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.plan$1 = plan$1;
            }
        });
    }

    public static LogicalPlan useCachedData(SQLContext $this, LogicalPlan plan) {
        return (LogicalPlan)plan.transformDown((PartialFunction)new Serializable($this){
            private final /* synthetic */ SQLContext $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.$outer.lookupCachedData(A1).map((Function1)new Serializable(this, A1){
                    private final LogicalPlan x1$1;

                    public final InMemoryRelation apply(CachedData x$2) {
                        return x$2.cachedRepresentation().withOutput((Seq<Attribute>)this.x1$1.output());
                    }
                    {
                        this.x1$1 = x1$1;
                    }
                }).getOrElse((Function0)new Serializable(this, A1){
                    private final LogicalPlan x1$1;

                    public final LogicalPlan apply() {
                        return this.x1$1;
                    }
                    {
                        this.x1$1 = x1$1;
                    }
                });
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void invalidateCache(SQLContext $this, LogicalPlan plan) {
        CacheManager$class.writeLock($this, (Function0)new Serializable($this, plan){
            private final /* synthetic */ SQLContext $outer;
            public final LogicalPlan plan$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$CacheManager$$cachedData().foreach((Function1)new Serializable(this){
                    private final /* synthetic */ CacheManager$.anonfun.invalidateCache.1 $outer;

                    public final void apply(CachedData x0$1) {
                        CachedData cachedData = x0$1;
                        if (cachedData.plan().collect((PartialFunction)new Serializable(this){
                            private final /* synthetic */ CacheManager$$anonfun$invalidateCache$1$.anonfun.apply.mcV.sp.2 $outer;

                            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                A1 A1 = x2;
                                Object object = A1.sameResult(this.$outer.org$apache$spark$sql$CacheManager$$anonfun$$anonfun$$$outer().plan$2) ? A1 : function1.apply(x2);
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(LogicalPlan x2) {
                                LogicalPlan logicalPlan = x2;
                                boolean bl = logicalPlan.sameResult(this.$outer.org$apache$spark$sql$CacheManager$$anonfun$$anonfun$$$outer().plan$2);
                                return bl;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).nonEmpty()) {
                            cachedData.cachedRepresentation().recache();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }

                    public /* synthetic */ CacheManager$.anonfun.invalidateCache.1 org$apache$spark$sql$CacheManager$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.plan$2 = plan$2;
            }
        });
    }

    public static void $init$(SQLContext $this) {
        $this.org$apache$spark$sql$CacheManager$_setter_$org$apache$spark$sql$CacheManager$$cachedData_$eq(new ArrayBuffer());
        $this.org$apache$spark$sql$CacheManager$_setter_$org$apache$spark$sql$CacheManager$$cacheLock_$eq(new ReentrantReadWriteLock());
    }
}

