/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.text;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.BufferHolder;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.execution.datasources.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat$$anonfun$buildReader$2$;
import org.apache.spark.sql.execution.datasources.text.TextOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u0001E\u0011a\u0002V3yi\u001aKG.\u001a$pe6\fGO\u0003\u0002\u0004\t\u0005!A/\u001a=u\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003'Q+\u0007\u0010\u001e\"bg\u0016$g)\u001b7f\r>\u0014X.\u0019;\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011aB:pkJ\u001cWm]\u0005\u00037a\u0011!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;fe\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\u0006E\u0001!\teI\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012\u0001\n\t\u0003K-r!AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\na\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!f\n\u0005\u0006_\u0001!I\u0001M\u0001\rm\u0016\u0014\u0018NZ=TG\",W.\u0019\u000b\u0003cQ\u0002\"A\n\u001a\n\u0005M:#\u0001B+oSRDQ!\u000e\u0018A\u0002Y\naa]2iK6\f\u0007CA\u001c;\u001b\u0005A$BA\u001d\t\u0003\u0015!\u0018\u0010]3t\u0013\tY\u0004H\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!\u0010\u0001\u0005By\n1\"\u001b8gKJ\u001c6\r[3nCR!qH\u0011%N!\r1\u0003IN\u0005\u0003\u0003\u001e\u0012aa\u00149uS>t\u0007\"B\"=\u0001\u0004!\u0015\u0001D:qCJ\\7+Z:tS>t\u0007CA#G\u001b\u0005A\u0011BA$\t\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u0015IE\b1\u0001K\u0003\u001dy\u0007\u000f^5p]N\u0004B!J&%I%\u0011A*\f\u0002\u0004\u001b\u0006\u0004\b\"\u0002(=\u0001\u0004y\u0015!\u00024jY\u0016\u001c\bc\u0001)Y7:\u0011\u0011K\u0016\b\u0003%Vk\u0011a\u0015\u0006\u0003)B\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0015\n\u0005];\u0013a\u00029bG.\fw-Z\u0005\u00033j\u00131aU3r\u0015\t9v\u0005\u0005\u0002]C6\tQL\u0003\u0002_?\u0006\u0011am\u001d\u0006\u0003A2\ta\u0001[1e_>\u0004\u0018B\u00012^\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0006I\u0002!\t%Z\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u0006M&T'o\u001d\t\u0003'\u001dL!\u0001\u001b\u0003\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000b\r\u001b\u0007\u0019\u0001#\t\u000b-\u001c\u0007\u0019\u00017\u0002\u0007)|'\r\u0005\u0002na6\taN\u0003\u0002p?\u0006IQ.\u00199sK\u0012,8-Z\u0005\u0003c:\u00141AS8c\u0011\u0015I5\r1\u0001K\u0011\u0015!8\r1\u00017\u0003)!\u0017\r^1TG\",W.\u0019\u0005\u0006m\u0002!\te^\u0001\fEVLG\u000e\u001a*fC\u0012,'\u000fF\by\u0003\u001f\t\t\"a\u0005\u0002\u0018\u0005m\u0011qEA\u0015!\u00111\u0013p\u001f@\n\u0005i<#!\u0003$v]\u000e$\u0018n\u001c82!\t\u0019B0\u0003\u0002~\t\ty\u0001+\u0019:uSRLwN\\3e\r&dW\r\u0005\u0003Q\u007f\u0006\r\u0011bAA\u00015\nA\u0011\n^3sCR|'\u000f\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI\u0001C\u0001\tG\u0006$\u0018\r\\=ti&!\u0011QBA\u0004\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000b\r+\b\u0019\u0001#\t\u000bQ,\b\u0019\u0001\u001c\t\r\u0005UQ\u000f1\u00017\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007BBA\rk\u0002\u0007a'\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u000f\u0005uQ\u000f1\u0001\u0002 \u00059a-\u001b7uKJ\u001c\b\u0003\u0002)Y\u0003C\u00012aFA\u0012\u0013\r\t)\u0003\u0007\u0002\u0007\r&dG/\u001a:\t\u000b%+\b\u0019\u0001&\t\u000f\u0005-R\u000f1\u0001\u0002.\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\r`\u0003\u0011\u0019wN\u001c4\n\t\u0005]\u0012\u0011\u0007\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8")
public class TextFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "text";
    }

    private void verifySchema(StructType schema) {
        DataType tpe;
        if (schema.size() != 1) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Text data source supports only a single column, and you have ", " columns."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)schema.size())})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        DataType dataType = tpe = schema.apply(0).dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Text data source supports only a string column, but you have ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tpe.simpleString()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)new StructType().add("value", (DataType)StringType$.MODULE$));
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        Configuration conf = job.getConfiguration();
        Option compressionCodec = options.get((Object)"compression").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return CompressionCodecs$.MODULE$.getCodecClassName(name);
            }
        });
        compressionCodec.foreach((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(String codec) {
                CompressionCodecs$.MODULE$.setCodecConfiguration(this.conf$1, codec);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, Option<Object> bucketId, StructType dataSchema, TaskAttemptContext context) {
                if (bucketId.isDefined()) {
                    throw new AnalysisException("Text doesn't support bucketing", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                return new TextOutputWriter(path, dataSchema, context);
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.assert(requiredSchema.length() <= 1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Text data source only produces a single data column named \"value\".";
            }
        });
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return new Serializable(this, requiredSchema, broadcastedHadoopConf){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;
            private final Broadcast broadcastedHadoopConf$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                Iterator<B> iterator2;
                HadoopFileLinesReader reader = new HadoopFileLinesReader(file, ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value());
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(this, reader){
                    public static final long serialVersionUID = 0L;
                    public final HadoopFileLinesReader reader$1;

                    public final TaskContext apply(TaskContext x$1) {
                        return x$1.addTaskCompletionListener((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildReader$2$$anonfun$apply$1 $outer;

                            public final void apply(TaskContext x$2) {
                                this.$outer.reader$1.close();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.reader$1 = reader$1;
                    }
                });
                if (this.requiredSchema$1.isEmpty()) {
                    UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
                    iterator2 = reader.map(new Serializable(this, emptyUnsafeRow){
                        public static final long serialVersionUID = 0L;
                        private final UnsafeRow emptyUnsafeRow$1;

                        public final UnsafeRow apply(Text x$3) {
                            return this.emptyUnsafeRow$1;
                        }
                        {
                            this.emptyUnsafeRow$1 = emptyUnsafeRow$1;
                        }
                    });
                } else {
                    UnsafeRow unsafeRow = new UnsafeRow(1);
                    BufferHolder bufferHolder = new BufferHolder(unsafeRow);
                    UnsafeRowWriter unsafeRowWriter = new UnsafeRowWriter(bufferHolder, 1);
                    iterator2 = reader.map(new Serializable(this, unsafeRow, bufferHolder, unsafeRowWriter){
                        public static final long serialVersionUID = 0L;
                        private final UnsafeRow unsafeRow$1;
                        private final BufferHolder bufferHolder$1;
                        private final UnsafeRowWriter unsafeRowWriter$1;

                        public final UnsafeRow apply(Text line) {
                            this.bufferHolder$1.reset();
                            this.unsafeRowWriter$1.write(0, line.getBytes(), 0, line.getLength());
                            this.unsafeRow$1.setTotalSize(this.bufferHolder$1.totalSize());
                            return this.unsafeRow$1;
                        }
                        {
                            this.unsafeRow$1 = unsafeRow$1;
                            this.bufferHolder$1 = bufferHolder$1;
                            this.unsafeRowWriter$1 = unsafeRowWriter$1;
                        }
                    });
                }
                return iterator2;
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
            }
        };
    }
}

