/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.BucketSpec;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.ListingFileCatalog;
import org.apache.spark.sql.execution.datasources.ListingFileCatalog$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r\u001dc\u0001B\u0001\u0003\u0001=\u0011\u0001CR5mKN#(/Z1n'>,(oY3\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\f\u001b!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0007'>,(oY3\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005}a\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005a1\u000f]1sWN+7o]5p]B\u00111\u0005J\u0007\u0002\r%\u0011QE\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005!\u0001/\u0019;i!\tICF\u0004\u0002\u0012U%\u00111FE\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,%!A\u0001\u0007\u0001B\u0001B\u0003%\u0001&A\ngS2,gi\u001c:nCR\u001cE.Y:t\u001d\u0006lW\r\u0003\u00053\u0001\t\u0015\r\u0011\"\u00114\u0003\u0019\u00198\r[3nCV\tA\u0007\u0005\u00026q5\taG\u0003\u00028\r\u0005)A/\u001f9fg&\u0011\u0011H\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u000fM\u001c\u0007.Z7bA!AQ\b\u0001B\u0001B\u0003%\u0001&\u0001\u0007nKR\fG-\u0019;b!\u0006$\b\u000e\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0003\u001dy\u0007\u000f^5p]N\u0004B!K!)Q%\u0011!I\f\u0002\u0004\u001b\u0006\u0004\b\"\u0002#\u0001\t\u0003)\u0015A\u0002\u001fj]&$h\bF\u0004G\u000f\"K%j\u0013'\u0011\u0005]\u0001\u0001\"B\u0011D\u0001\u0004\u0011\u0003\"B\u0014D\u0001\u0004A\u0003\"\u0002\u0019D\u0001\u0004A\u0003\"\u0002\u001aD\u0001\u0004!\u0004\"B\u001fD\u0001\u0004A\u0003\"B D\u0001\u0004\u0001\u0005b\u0002(\u0001\u0005\u0004%IaT\u0001\u000eg>,(oY3PaRLwN\\:\u0016\u0003A\u0003\"aF)\n\u0005I\u0013!!\u0005$jY\u0016\u001cFO]3b[>\u0003H/[8og\"1A\u000b\u0001Q\u0001\nA\u000bab]8ve\u000e,w\n\u001d;j_:\u001c\b\u0005C\u0004W\u0001\t\u0007I\u0011B,\u0002#E,\u0018\r\\5gS\u0016$')Y:f!\u0006$\b.F\u0001Y!\tIf,D\u0001[\u0015\tYF,\u0001\u0002gg*\u0011QLC\u0001\u0007Q\u0006$wn\u001c9\n\u0005}S&\u0001\u0002)bi\"Da!\u0019\u0001!\u0002\u0013A\u0016AE9vC2Lg-[3e\u0005\u0006\u001cX\rU1uQ\u0002Bqa\u0019\u0001C\u0002\u0013%A-A\u0006nKR\fG-\u0019;b\u0019><W#A3\u0011\u0005]1\u0017BA4\u0003\u0005M1\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cW\rT8h\u0011\u0019I\u0007\u0001)A\u0005K\u0006aQ.\u001a;bI\u0006$\u0018\rT8hA!91\u000e\u0001a\u0001\n\u0013a\u0017AC7bq\n\u000bGo\u00195JIV\tQ\u000e\u0005\u0002\u0012]&\u0011qN\u0005\u0002\u0005\u0019>tw\rC\u0004r\u0001\u0001\u0007I\u0011\u0002:\u0002\u001d5\f\u0007PQ1uG\"LEm\u0018\u0013fcR\u00111O\u001e\t\u0003#QL!!\u001e\n\u0003\tUs\u0017\u000e\u001e\u0005\boB\f\t\u00111\u0001n\u0003\rAH%\r\u0005\u0007s\u0002\u0001\u000b\u0015B7\u0002\u00175\f\u0007PQ1uG\"LE\r\t\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0003Ai\u0017\r\u001f$jY\u0016\u001c\b+\u001a:CCR\u001c\u0007.F\u0001~!\u0011\tb0!\u0001\n\u0005}\u0014\"AB(qi&|g\u000eE\u0002\u0012\u0003\u0007I1!!\u0002\u0013\u0005\rIe\u000e\u001e\u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003~\u0003Ei\u0017\r\u001f$jY\u0016\u001c\b+\u001a:CCR\u001c\u0007\u000e\t\u0005\n\u0003\u001b\u0001!\u0019!C\u0001\u0003\u001f\t\u0011b]3f]\u001aKG.Z:\u0016\u0005\u0005E\u0001\u0003BA\n\u0005wq1aFA\u000b\u000f\u001d\t9B\u0001E\u0001\u00033\t\u0001CR5mKN#(/Z1n'>,(oY3\u0011\u0007]\tYB\u0002\u0004\u0002\u0005!\u0005\u0011QD\n\u0004\u00037\u0001\u0002b\u0002#\u0002\u001c\u0011\u0005\u0011\u0011\u0005\u000b\u0003\u00033)a!!\n\u0002\u001c\u0001i'!\u0003+j[\u0016\u001cH/Y7q\r\u001d\tI#a\u0007A\u0003W\u0011\u0011BR5mK\u0016sGO]=\u0014\u000f\u0005\u001d\u0002#!\f\u00024A\u0019\u0011#a\f\n\u0007\u0005E\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rE\u0002\u0012\u0003kI1!a\u000e\u0013\u0005\u001d\u0001&o\u001c3vGRD!bJA\u0014\u0005+\u0007I\u0011AA\u001e+\u0005A\u0003BCA \u0003O\u0011\t\u0012)A\u0005Q\u0005)\u0001/\u0019;iA!Y\u00111IA\u0014\u0005+\u0007I\u0011AA#\u0003%!\u0018.\\3ti\u0006l\u0007/\u0006\u0002\u0002HA!\u0011\u0011JA\u0012\u001b\t\tY\u0002C\u0006\u0002N\u0005\u001d\"\u0011#Q\u0001\n\u0005\u001d\u0013A\u0003;j[\u0016\u001cH/Y7qA!Q\u0011\u0011KA\u0014\u0005+\u0007I\u0011\u00017\u0002\u000f\t\fGo\u00195JI\"Q\u0011QKA\u0014\u0005#\u0005\u000b\u0011B7\u0002\u0011\t\fGo\u00195JI\u0002Bq\u0001RA\u0014\t\u0003\tI\u0006\u0006\u0005\u0002\\\u0005u\u0013qLA1!\u0011\tI%a\n\t\r\u001d\n9\u00061\u0001)\u0011!\t\u0019%a\u0016A\u0002\u0005\u001d\u0003bBA)\u0003/\u0002\r!\u001c\u0005\u000b\u0003K\n9#!A\u0005\u0002\u0005\u001d\u0014\u0001B2paf$\u0002\"a\u0017\u0002j\u0005-\u0014Q\u000e\u0005\tO\u0005\r\u0004\u0013!a\u0001Q!Q\u00111IA2!\u0003\u0005\r!a\u0012\t\u0013\u0005E\u00131\rI\u0001\u0002\u0004i\u0007BCA9\u0003O\t\n\u0011\"\u0001\u0002t\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA;U\rA\u0013qO\u0016\u0003\u0003s\u0002B!a\u001f\u0002\u00066\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0011\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\b\u0006u$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u00111RA\u0014#\u0003%\t!!$\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0012\u0016\u0005\u0003\u000f\n9\b\u0003\u0006\u0002\u0014\u0006\u001d\u0012\u0013!C\u0001\u0003+\u000babY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0018*\u001aQ.a\u001e\t\u0015\u0005m\u0015qEA\u0001\n\u0003\ni*A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003?\u0003B!!)\u0002,6\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+\u0001\u0003mC:<'BAAU\u0003\u0011Q\u0017M^1\n\u00075\n\u0019\u000b\u0003\u0006\u00020\u0006\u001d\u0012\u0011!C\u0001\u0003c\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0001\t\u0015\u0005U\u0016qEA\u0001\n\u0003\t9,\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005e\u0016q\u0018\t\u0004#\u0005m\u0016bAA_%\t\u0019\u0011I\\=\t\u0013]\f\u0019,!AA\u0002\u0005\u0005\u0001BCAb\u0003O\t\t\u0011\"\u0011\u0002F\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002HB1\u0011\u0011ZAh\u0003sk!!a3\u000b\u0007\u00055'#\u0001\u0006d_2dWm\u0019;j_:LA!!5\u0002L\nA\u0011\n^3sCR|'\u000f\u0003\u0006\u0002V\u0006\u001d\u0012\u0011!C\u0001\u0003/\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00033\fy\u000eE\u0002\u0012\u00037L1!!8\u0013\u0005\u001d\u0011un\u001c7fC:D\u0011b^Aj\u0003\u0003\u0005\r!!/\t\u0015\u0005\r\u0018qEA\u0001\n\u0003\n)/\u0001\u0005iCND7i\u001c3f)\t\t\t\u0001\u0003\u0006\u0002j\u0006\u001d\u0012\u0011!C!\u0003W\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003?C!\"a<\u0002(\u0005\u0005I\u0011IAy\u0003\u0019)\u0017/^1mgR!\u0011\u0011\\Az\u0011%9\u0018Q^A\u0001\u0002\u0004\tIl\u0002\u0006\u0002x\u0006m\u0011\u0011!E\u0001\u0003s\f\u0011BR5mK\u0016sGO]=\u0011\t\u0005%\u00131 \u0004\u000b\u0003S\tY\"!A\t\u0002\u0005u8CBA~\u0003\u007f\fi\u0003\u0005\u0006\u0003\u0002\t\u001d\u0001&a\u0012n\u00037j!Aa\u0001\u000b\u0007\t\u0015!#A\u0004sk:$\u0018.\\3\n\t\t%!1\u0001\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004b\u0002#\u0002|\u0012\u0005!Q\u0002\u000b\u0003\u0003sD!\"!;\u0002|\u0006\u0005IQIAv\u0011)\u0011\u0019\"a?\u0002\u0002\u0013\u0005%QC\u0001\u0006CB\u0004H.\u001f\u000b\t\u00037\u00129B!\u0007\u0003\u001c!1qE!\u0005A\u0002!B\u0001\"a\u0011\u0003\u0012\u0001\u0007\u0011q\t\u0005\b\u0003#\u0012\t\u00021\u0001n\u0011)\u0011y\"a?\u0002\u0002\u0013\u0005%\u0011E\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Ca\u000b\u0011\tEq(Q\u0005\t\b#\t\u001d\u0002&a\u0012n\u0013\r\u0011IC\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u0015\t5\"QDA\u0001\u0002\u0004\tY&A\u0002yIAB!B!\r\u0002|\u0006\u0005I\u0011\u0002B\u001a\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tU\u0002\u0003BAQ\u0005oIAA!\u000f\u0002$\n1qJ\u00196fGR4qA!\u0010\u0002\u001c\u0001\u0011yD\u0001\u0007TK\u0016tg)\u001b7fg6\u000b\u0007oE\u0002\u0003<AA!Ba\u0011\u0003<\t\u0005\t\u0015!\u0003n\u0003!i\u0017\r_!hK6\u001b\bb\u0002#\u0003<\u0011\u0005!q\t\u000b\u0005\u0005\u0013\u0012Y\u0005\u0005\u0003\u0002J\tm\u0002b\u0002B\"\u0005\u000b\u0002\r!\u001c\u0005\u000b\u0005\u001f\u0012YD1A\u0005\n\tE\u0013aA7baV\u0011!1\u000b\t\b\u0005+\u0012Y\u0006KA$\u001b\t\u00119F\u0003\u0003\u0003Z\u0005\u001d\u0016\u0001B;uS2LAA!\u0018\u0003X\t9\u0001*Y:i\u001b\u0006\u0004\b\"\u0003B1\u0005w\u0001\u000b\u0011\u0002B*\u0003\u0011i\u0017\r\u001d\u0011\t\u0015\t\u0015$1\ba\u0001\n\u0013\t)%A\bmCR,7\u000f\u001e+j[\u0016\u001cH/Y7q\u0011)\u0011IGa\u000fA\u0002\u0013%!1N\u0001\u0014Y\u0006$Xm\u001d;US6,7\u000f^1na~#S-\u001d\u000b\u0004g\n5\u0004\"C<\u0003h\u0005\u0005\t\u0019AA$\u0011%\u0011\tHa\u000f!B\u0013\t9%\u0001\tmCR,7\u000f\u001e+j[\u0016\u001cH/Y7qA!Q!Q\u000fB\u001e\u0001\u0004%I!!\u0012\u0002%1\f7\u000f\u001e)ve\u001e,G+[7fgR\fW\u000e\u001d\u0005\u000b\u0005s\u0012Y\u00041A\u0005\n\tm\u0014A\u00067bgR\u0004VO]4f)&lWm\u001d;b[B|F%Z9\u0015\u0007M\u0014i\bC\u0005x\u0005o\n\t\u00111\u0001\u0002H!I!\u0011\u0011B\u001eA\u0003&\u0011qI\u0001\u0014Y\u0006\u001cH\u000fU;sO\u0016$\u0016.\\3ti\u0006l\u0007\u000f\t\u0005\t\u0005\u000b\u0013Y\u0004\"\u0001\u0003\b\u0006\u0019\u0011\r\u001a3\u0015\u000bM\u0014IIa#\t\r\u001d\u0012\u0019\t1\u0001)\u0011!\t\u0019Ea!A\u0002\u0005\u001d\u0003\u0002\u0003BH\u0005w!\tA!%\u0002\u0013%\u001ch*Z<GS2,GCBAm\u0005'\u0013)\n\u0003\u0004(\u0005\u001b\u0003\r\u0001\u000b\u0005\t\u0003\u0007\u0012i\t1\u0001\u0002H!A!\u0011\u0014B\u001e\t\u0003\t)/A\u0003qkJ<W\r\u0003\u0005\u0003\u001e\nmB\u0011AAY\u0003\u0011\u0019\u0018N_3\t\u0011\t\u0005&1\bC\u0001\u0005G\u000b!\"\u00197m\u000b:$(/[3t+\t\u0011)\u000b\u0005\u0004\u0003(\n]&Q\u0018\b\u0005\u0005S\u0013\u0019L\u0004\u0003\u0003,\nEVB\u0001BW\u0015\r\u0011yKD\u0001\u0007yI|w\u000e\u001e \n\u0003MI1A!.\u0013\u0003\u001d\u0001\u0018mY6bO\u0016LAA!/\u0003<\n\u00191+Z9\u000b\u0007\tU&\u0003\u0005\u0004\u0012\u0005\u007fC\u0013qI\u0005\u0004\u0005\u0003\u0014\"A\u0002+va2,'\u0007\u0003\u0005\u0003F\u0002\u0001\u000b\u0011BA\t\u0003)\u0019X-\u001a8GS2,7\u000f\t\u0005\b\u0005\u0013\u0004A\u0011\u0002Bf\u000391W\r^2i\u001b\u0006DxJ\u001a4tKR$\"A!4\u0011\u0007]\u0011y-C\u0002\u0003R\n\u0011!\u0002T8oO>3gm]3u\u0011\u001d\u0011)\u000e\u0001C\u0001\u0005/\f!c^5uQ\n\u000bGo\u00195j]\u001edunY6fIV!!\u0011\u001cBp)\u0011\u0011YNa;\u0011\t\tu'q\u001c\u0007\u0001\t!\u0011\tOa5C\u0002\t\r(!\u0001+\u0012\t\t\u0015\u0018\u0011\u0018\t\u0004#\t\u001d\u0018b\u0001Bu%\t9aj\u001c;iS:<\u0007\"\u0003Bw\u0005'$\t\u0019\u0001Bx\u0003\u00111WO\\2\u0011\u000bE\u0011\tPa7\n\u0007\tM(C\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\u00119\u0010\u0001C\u0001\u0005s\fQbY;se\u0016tGo\u00144gg\u0016$XC\u0001Bg\u0011\u001d\u0011i\u0010\u0001C!\u0005\u007f\f\u0001bZ3u\u0005\u0006$8\r\u001b\u000b\u0007\u0007\u0003\u0019ib!\u000b\u0011\t\r\r1q\u0003\b\u0005\u0007\u000b\u0019)B\u0004\u0003\u0004\b\rMa\u0002BB\u0005\u0007#qAaa\u0003\u0004\u00109!!1VB\u0007\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0019!Q\u0017\u0004\n\t\re11\u0004\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1A!.\u0007\u0011!\u0019yBa?A\u0002\r\u0005\u0012!B:uCJ$\b\u0003B\t\u007f\u0007G\u00012aFB\u0013\u0013\r\u00199C\u0001\u0002\u0007\u001f\u001a47/\u001a;\t\u0011\r-\"1 a\u0001\u0007G\t1!\u001a8e\u0011\u001d\u0019y\u0003\u0001C\u0005\u0007c\tQBZ3uG\"\fE\u000e\u001c$jY\u0016\u001cHCAB\u001a!\u0019\u00119Ka.\u00046A)\u0011Ca0)[\"91\u0011\b\u0001\u0005B\rm\u0012!C4fi>3gm]3u+\t\u0019\t\u0003C\u0004\u0002j\u0002!\tea\u0010\u0015\u0003!Bqaa\u0011\u0001\t\u0003\u001a)%\u0001\u0003ti>\u0004H#A:")
public class FileStreamSource
implements Source,
Logging {
    private final SparkSession sparkSession;
    private final String fileFormatClassName;
    private final StructType schema;
    private final Map<String, String> options;
    private final FileStreamOptions org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions;
    private final Path qualifiedBasePath;
    private final FileStreamSourceLog metadataLog;
    private long org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId;
    private final Option<Object> org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch;
    private final SeenFilesMap seenFiles;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    public FileStreamOptions org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions;
    }

    private Path qualifiedBasePath() {
        return this.qualifiedBasePath;
    }

    private FileStreamSourceLog metadataLog() {
        return this.metadataLog;
    }

    public long org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId;
    }

    private void org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId_$eq(long x$1) {
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId = x$1;
    }

    public Option<Object> org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch;
    }

    public SeenFilesMap seenFiles() {
        return this.seenFiles;
    }

    private synchronized LongOffset fetchMaxOffset() {
        Seq newFiles = (Seq)this.fetchAllFiles().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final boolean apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String path = (String)tuple2._1();
                    long timestamp = tuple2._2$mcJ$sp();
                    boolean bl = this.$outer.seenFiles().isNewFile(path, timestamp);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq batchFiles = this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().nonEmpty() ? (Seq)newFiles.take(BoxesRunTime.unboxToInt((Object)this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().get())) : newFiles;
        batchFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(Tuple2<String, Object> file) {
                this.$outer.seenFiles().add((String)file._1(), file._2$mcJ$sp());
                this.$outer.logDebug((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int numPurged = this.seenFiles().purge();
        this.logTrace((Function0<String>)new Serializable(this, newFiles, batchFiles, numPurged){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;
            private final Seq newFiles$1;
            private final Seq batchFiles$1;
            private final int numPurged$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |Number of new files = ", "\n         |Number of files selected for batch = ", "\n         |Number of seen files = ", "\n         |Number of files purged from tracking map = ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.newFiles$1.size()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.seenFiles().size()), BoxesRunTime.boxToInteger((int)this.numPurged$1)})))).stripMargin();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newFiles$1 = newFiles$1;
                this.batchFiles$1 = batchFiles$1;
                this.numPurged$1 = numPurged$1;
            }
        });
        if (batchFiles.nonEmpty()) {
            this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId_$eq(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId() + 1L);
            this.metadataLog().add(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId(), (FileEntry[])((TraversableOnce)batchFiles.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;

                public final FileEntry apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String path = (String)tuple2._1();
                        long timestamp = tuple2._2$mcJ$sp();
                        FileEntry fileEntry = new FileEntry(path, timestamp, this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId());
                        return fileEntry;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileEntry.class)));
            this.logInfo((Function0<String>)new Serializable(this, batchFiles){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;
                private final Seq batchFiles$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max batch id increased to ", " with ", " new files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchFiles$1 = batchFiles$1;
                }
            });
        }
        return new LongOffset(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId());
    }

    public synchronized <T> T withBatchingLocked(Function0<T> func) {
        return (T)func.apply();
    }

    public synchronized LongOffset currentOffset() {
        return new LongOffset(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId());
    }

    @Override
    public Dataset<Row> getBatch(Option<Offset> start, Offset end) {
        long endId;
        long startId = BoxesRunTime.unboxToLong((Object)start.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Offset x$2) {
                return ((LongOffset)x$2).offset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        Predef$.MODULE$.assert(startId <= (endId = ((LongOffset)end).offset()));
        FileEntry[] files = (FileEntry[])Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().get((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(startId + 1L))), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)endId)))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<FileEntry> apply(Tuple2<Object, FileEntry[]> x$3) {
                return Predef$.MODULE$.refArrayOps((Object[])x$3._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileEntry.class)));
        this.logInfo((Function0<String>)new Serializable(this, startId, endId, files){
            public static final long serialVersionUID = 0L;
            private final long startId$1;
            private final long endId$1;
            private final FileEntry[] files$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing ", " files from ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$1.length), BoxesRunTime.boxToLong((long)(this.startId$1 + 1L)), BoxesRunTime.boxToLong((long)this.endId$1)}));
            }
            {
                this.startId$1 = startId$1;
                this.endId$1 = endId$1;
                this.files$1 = files$1;
            }
        });
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final FileEntry[] files$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)Predef$.MODULE$.refArrayOps((Object[])this.files$1).mkString("\n\t")).toString();
            }
            {
                this.files$1 = files$1;
            }
        });
        SparkSession x$7 = this.sparkSession;
        Seq x$8 = (Seq)Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileEntry x$4) {
                return x$4.path();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Some x$9 = new Some((Object)this.schema());
        String x$10 = this.fileFormatClassName;
        Map<String, String> x$11 = this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().optionMapWithoutPath();
        Seq<String> x$12 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$13 = DataSource$.MODULE$.apply$default$6();
        DataSource newDataSource = new DataSource(x$7, x$10, (Seq<String>)x$8, (Option<StructType>)x$9, x$12, x$13, x$11);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new LogicalRelation(newDataSource.resolveRelation(false), LogicalRelation$.MODULE$.apply$default$2(), LogicalRelation$.MODULE$.apply$default$3()));
    }

    private Seq<Tuple2<String, Object>> fetchAllFiles() {
        long startTime = System.nanoTime();
        Seq globbedPaths = SparkHadoopUtil$.MODULE$.get().globPathIfNecessary(this.qualifiedBasePath());
        ListingFileCatalog catalog = new ListingFileCatalog(this.sparkSession, (Seq<Path>)globbedPaths, this.options, (Option<StructType>)new Some((Object)new StructType()), ListingFileCatalog$.MODULE$.$lessinit$greater$default$5());
        Seq files = (Seq)((TraversableLike)catalog.allFiles().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(FileStatus x$5) {
                return x$5.getModificationTime();
            }
        }, (Ordering)Ordering.Long$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(FileStatus status) {
                return new Tuple2((Object)status.getPath().toUri().toString(), (Object)BoxesRunTime.boxToLong((long)status.getModificationTime()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        long endTime = System.nanoTime();
        double listingTimeMs = ((double)endTime - (double)startTime) / (double)1000000;
        if (listingTimeMs > (double)2000) {
            this.logWarning((Function0<String>)new Serializable(this, files, listingTimeMs){
                public static final long serialVersionUID = 0L;
                private final Seq files$2;
                private final double listingTimeMs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                }
                {
                    this.files$2 = files$2;
                    this.listingTimeMs$1 = listingTimeMs$1;
                }
            });
        } else {
            this.logTrace((Function0<String>)new Serializable(this, files, listingTimeMs){
                public static final long serialVersionUID = 0L;
                private final Seq files$2;
                private final double listingTimeMs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                }
                {
                    this.files$2 = files$2;
                    this.listingTimeMs$1 = listingTimeMs$1;
                }
            });
        }
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final Seq files$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)this.files$2.mkString("\n\t")).toString();
            }
            {
                this.files$2 = files$2;
            }
        });
        return files;
    }

    @Override
    public Option<Offset> getOffset() {
        return new Some((Object)this.fetchMaxOffset()).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LongOffset x$6) {
                return x$6.offset() == -1L;
            }
        });
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileStreamSource[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.qualifiedBasePath()}));
    }

    @Override
    public void stop() {
    }

    public FileStreamSource(SparkSession sparkSession, String path, String fileFormatClassName, StructType schema, String metadataPath, Map<String, String> options) {
        this.sparkSession = sparkSession;
        this.fileFormatClassName = fileFormatClassName;
        this.schema = schema;
        this.options = options;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions = new FileStreamOptions(options);
        FileSystem fs = new Path(path).getFileSystem(sparkSession.sessionState().newHadoopConf());
        this.qualifiedBasePath = fs.makeQualified(new Path(path));
        this.metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), sparkSession, metadataPath);
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId = BoxesRunTime.unboxToLong((Object)this.metadataLog().getLatest().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, FileEntry[]> x$1) {
                return x$1._1$mcJ$sp();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch = this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().maxFilesPerTrigger();
        this.seenFiles = new SeenFilesMap(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().maxFileAgeMs());
        Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().allFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(FileEntry entry2) {
                this.$outer.seenFiles().add(entry2.path(), entry2.timestamp());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.seenFiles().purge();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxFilesPerBatch = ", ", maxFileAge = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch(), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().maxFileAgeMs())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static class FileEntry
    implements Serializable,
    Product {
        private final String path;
        private final long timestamp;
        private final long batchId;

        public String path() {
            return this.path;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long batchId() {
            return this.batchId;
        }

        public FileEntry copy(String path, long timestamp, long batchId) {
            return new FileEntry(path, timestamp, batchId);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.batchId();
        }

        public String productPrefix() {
            return "FileEntry";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.batchId());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                case 0: {
                    object = this.path();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileEntry;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.batchId()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            FileEntry fileEntry = (FileEntry)x$1;
            String string = this.path();
            String string2 = fileEntry.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.timestamp() != fileEntry.timestamp()) return false;
            if (this.batchId() != fileEntry.batchId()) return false;
            if (!fileEntry.canEqual(this)) return false;
            return true;
        }

        public FileEntry(String path, long timestamp, long batchId) {
            this.path = path;
            this.timestamp = timestamp;
            this.batchId = batchId;
            Product.class.$init$((Product)this);
        }
    }

    public static class SeenFilesMap {
        private final long maxAgeMs;
        private final HashMap<String, Object> map;
        private long latestTimestamp;
        private long lastPurgeTimestamp;

        private HashMap<String, Object> map() {
            return this.map;
        }

        private long latestTimestamp() {
            return this.latestTimestamp;
        }

        private void latestTimestamp_$eq(long x$1) {
            this.latestTimestamp = x$1;
        }

        private long lastPurgeTimestamp() {
            return this.lastPurgeTimestamp;
        }

        private void lastPurgeTimestamp_$eq(long x$1) {
            this.lastPurgeTimestamp = x$1;
        }

        public void add(String path, long timestamp) {
            this.map().put(path, BoxesRunTime.boxToLong((long)timestamp));
            if (timestamp > this.latestTimestamp()) {
                this.latestTimestamp_$eq(timestamp);
            }
        }

        public boolean isNewFile(String path, long timestamp) {
            return timestamp >= this.lastPurgeTimestamp() && !this.map().containsKey(path);
        }

        /*
         * WARNING - void declaration
         */
        public int purge() {
            void var2_2;
            this.lastPurgeTimestamp_$eq(this.latestTimestamp() - this.maxAgeMs);
            java.util.Iterator<Map.Entry<String, Object>> iter = this.map().entrySet().iterator();
            int count2 = 0;
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry2 = iter.next();
                if (BoxesRunTime.unboxToLong((Object)entry2.getValue()) >= this.lastPurgeTimestamp()) continue;
                ++count2;
                iter.remove();
            }
            return (int)var2_2;
        }

        public int size() {
            return this.map().size();
        }

        public Seq<Tuple2<String, Object>> allEntries() {
            return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.map()).asScala()).toSeq();
        }

        public SeenFilesMap(long maxAgeMs) {
            this.maxAgeMs = maxAgeMs;
            Predef$.MODULE$.require(maxAgeMs >= 0L);
            this.map = new HashMap();
            this.latestTimestamp = 0L;
            this.lastPurgeTimestamp = 0L;
        }
    }
}

