/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.vectorized.ColumnVector;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public final class ColumnarBatch {
    private static final int DEFAULT_BATCH_SIZE = 4096;
    private static MemoryMode DEFAULT_MEMORY_MODE = MemoryMode.ON_HEAP;
    private final StructType schema;
    private final int capacity;
    private int numRows;
    private final ColumnVector[] columns;
    private final boolean[] filteredRows;
    private final Set<Integer> nullFilteredColumns;
    private int numRowsFiltered = 0;
    final Row row;

    public static ColumnarBatch allocate(StructType schema, MemoryMode memMode) {
        return new ColumnarBatch(schema, 4096, memMode);
    }

    public static ColumnarBatch allocate(StructType type) {
        return new ColumnarBatch(type, 4096, DEFAULT_MEMORY_MODE);
    }

    public static ColumnarBatch allocate(StructType schema, MemoryMode memMode, int maxRows) {
        return new ColumnarBatch(schema, maxRows, memMode);
    }

    public void close() {
        for (ColumnVector c : this.columns) {
            c.close();
        }
    }

    public Iterator<Row> rowIterator() {
        final int maxRows = this.numRows();
        final Row row = new Row(this);
        return new Iterator<Row>(){
            int rowId = 0;

            @Override
            public boolean hasNext() {
                while (this.rowId < maxRows && ColumnarBatch.this.filteredRows[this.rowId]) {
                    ++this.rowId;
                }
                return this.rowId < maxRows;
            }

            @Override
            public Row next() {
                while (this.rowId < maxRows && ColumnarBatch.this.filteredRows[this.rowId]) {
                    ++this.rowId;
                }
                if (this.rowId >= maxRows) {
                    throw new NoSuchElementException();
                }
                row.rowId = this.rowId++;
                return row;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void reset() {
        for (int i = 0; i < this.numCols(); ++i) {
            this.columns[i].reset();
        }
        if (this.numRowsFiltered > 0) {
            Arrays.fill(this.filteredRows, false);
        }
        this.numRows = 0;
        this.numRowsFiltered = 0;
    }

    public void setNumRows(int numRows) {
        assert (numRows <= this.capacity);
        this.numRows = numRows;
        for (int ordinal : this.nullFilteredColumns) {
            if (this.columns[ordinal].numNulls == 0) continue;
            for (int rowId = 0; rowId < numRows; ++rowId) {
                if (this.filteredRows[rowId] || !this.columns[ordinal].isNullAt(rowId)) continue;
                this.filteredRows[rowId] = true;
                ++this.numRowsFiltered;
            }
        }
    }

    public int numCols() {
        return this.columns.length;
    }

    public int numRows() {
        return this.numRows;
    }

    public int numValidRows() {
        assert (this.numRowsFiltered <= this.numRows);
        return this.numRows - this.numRowsFiltered;
    }

    public int capacity() {
        return this.capacity;
    }

    public ColumnVector column(int ordinal) {
        return this.columns[ordinal];
    }

    public void setColumn(int ordinal, ColumnVector column) {
        if (column instanceof OffHeapColumnVector) {
            throw new UnsupportedOperationException("Need to ref count columns.");
        }
        this.columns[ordinal] = column;
    }

    public Row getRow(int rowId) {
        assert (rowId >= 0);
        assert (rowId < this.numRows);
        this.row.rowId = rowId;
        return this.row;
    }

    public void markFiltered(int rowId) {
        assert (!this.filteredRows[rowId]);
        this.filteredRows[rowId] = true;
        ++this.numRowsFiltered;
    }

    public void filterNullsInColumn(int ordinal) {
        this.nullFilteredColumns.add(ordinal);
    }

    private ColumnarBatch(StructType schema, int maxRows, MemoryMode memMode) {
        this.schema = schema;
        this.capacity = maxRows;
        this.columns = new ColumnVector[schema.size()];
        this.nullFilteredColumns = new HashSet<Integer>();
        this.filteredRows = new boolean[maxRows];
        for (int i = 0; i < schema.fields().length; ++i) {
            StructField field = schema.fields()[i];
            this.columns[i] = ColumnVector.allocate(maxRows, field.dataType(), memMode);
        }
        this.row = new Row(this);
    }

    public static final class Row
    extends MutableRow {
        protected int rowId;
        private final ColumnarBatch parent;
        private final int fixedLenRowSize;
        private final ColumnVector[] columns;

        private Row(ColumnarBatch parent) {
            this.parent = parent;
            this.fixedLenRowSize = UnsafeRow.calculateFixedPortionByteSize((int)parent.numCols());
            this.columns = parent.columns;
        }

        protected Row(ColumnVector[] columns2) {
            this.parent = null;
            this.fixedLenRowSize = UnsafeRow.calculateFixedPortionByteSize((int)columns2.length);
            this.columns = columns2;
        }

        public void markFiltered() {
            this.parent.markFiltered(this.rowId);
        }

        public ColumnVector[] columns() {
            return this.columns;
        }

        public int numFields() {
            return this.columns.length;
        }

        public InternalRow copy() {
            GenericMutableRow row = new GenericMutableRow(this.columns.length);
            for (int i = 0; i < this.numFields(); ++i) {
                if (this.isNullAt(i)) {
                    row.setNullAt(i);
                    continue;
                }
                DataType dt = this.columns[i].dataType();
                if (dt instanceof BooleanType) {
                    row.setBoolean(i, this.getBoolean(i));
                    continue;
                }
                if (dt instanceof ByteType) {
                    row.setByte(i, this.getByte(i));
                    continue;
                }
                if (dt instanceof ShortType) {
                    row.setShort(i, this.getShort(i));
                    continue;
                }
                if (dt instanceof IntegerType) {
                    row.setInt(i, this.getInt(i));
                    continue;
                }
                if (dt instanceof LongType) {
                    row.setLong(i, this.getLong(i));
                    continue;
                }
                if (dt instanceof FloatType) {
                    row.setFloat(i, this.getFloat(i));
                    continue;
                }
                if (dt instanceof DoubleType) {
                    row.setDouble(i, this.getDouble(i));
                    continue;
                }
                if (dt instanceof StringType) {
                    row.update(i, (Object)this.getUTF8String(i));
                    continue;
                }
                if (dt instanceof BinaryType) {
                    row.update(i, (Object)this.getBinary(i));
                    continue;
                }
                if (dt instanceof DecimalType) {
                    DecimalType t = (DecimalType)dt;
                    row.setDecimal(i, this.getDecimal(i, t.precision(), t.scale()), t.precision());
                    continue;
                }
                if (dt instanceof DateType) {
                    row.setInt(i, this.getInt(i));
                    continue;
                }
                if (dt instanceof TimestampType) {
                    row.setLong(i, this.getLong(i));
                    continue;
                }
                throw new RuntimeException("Not implemented. " + dt);
            }
            return row;
        }

        public boolean anyNull() {
            throw new UnsupportedOperationException();
        }

        public boolean isNullAt(int ordinal) {
            return this.columns[ordinal].isNullAt(this.rowId);
        }

        public boolean getBoolean(int ordinal) {
            return this.columns[ordinal].getBoolean(this.rowId);
        }

        public byte getByte(int ordinal) {
            return this.columns[ordinal].getByte(this.rowId);
        }

        public short getShort(int ordinal) {
            return this.columns[ordinal].getShort(this.rowId);
        }

        public int getInt(int ordinal) {
            return this.columns[ordinal].getInt(this.rowId);
        }

        public long getLong(int ordinal) {
            return this.columns[ordinal].getLong(this.rowId);
        }

        public float getFloat(int ordinal) {
            return this.columns[ordinal].getFloat(this.rowId);
        }

        public double getDouble(int ordinal) {
            return this.columns[ordinal].getDouble(this.rowId);
        }

        public Decimal getDecimal(int ordinal, int precision, int scale) {
            return this.columns[ordinal].getDecimal(this.rowId, precision, scale);
        }

        public UTF8String getUTF8String(int ordinal) {
            return this.columns[ordinal].getUTF8String(this.rowId);
        }

        public byte[] getBinary(int ordinal) {
            return this.columns[ordinal].getBinary(this.rowId);
        }

        public CalendarInterval getInterval(int ordinal) {
            int months = this.columns[ordinal].getChildColumn(0).getInt(this.rowId);
            long microseconds = this.columns[ordinal].getChildColumn(1).getLong(this.rowId);
            return new CalendarInterval(months, microseconds);
        }

        public InternalRow getStruct(int ordinal, int numFields) {
            return this.columns[ordinal].getStruct(this.rowId);
        }

        public ArrayData getArray(int ordinal) {
            return this.columns[ordinal].getArray(this.rowId);
        }

        public MapData getMap(int ordinal) {
            throw new UnsupportedOperationException();
        }

        public Object get(int ordinal, DataType dataType) {
            throw new UnsupportedOperationException();
        }

        public void update(int ordinal, Object value) {
            if (value == null) {
                this.setNullAt(ordinal);
            } else {
                DataType dt = this.columns[ordinal].dataType();
                if (dt instanceof BooleanType) {
                    this.setBoolean(ordinal, (Boolean)value);
                } else if (dt instanceof IntegerType) {
                    this.setInt(ordinal, (Integer)value);
                } else if (dt instanceof ShortType) {
                    this.setShort(ordinal, (Short)value);
                } else if (dt instanceof LongType) {
                    this.setLong(ordinal, (Long)value);
                } else if (dt instanceof FloatType) {
                    this.setFloat(ordinal, ((Float)value).floatValue());
                } else if (dt instanceof DoubleType) {
                    this.setDouble(ordinal, (Double)value);
                } else if (dt instanceof DecimalType) {
                    DecimalType t = (DecimalType)dt;
                    this.setDecimal(ordinal, Decimal.apply((BigDecimal)((BigDecimal)value), (int)t.precision(), (int)t.scale()), t.precision());
                } else {
                    throw new UnsupportedOperationException("Datatype not supported " + dt);
                }
            }
        }

        public void setNullAt(int ordinal) {
            assert (!this.columns[ordinal].isConstant);
            this.columns[ordinal].putNull(this.rowId);
        }

        public void setBoolean(int ordinal, boolean value) {
            assert (!this.columns[ordinal].isConstant);
            this.columns[ordinal].putNotNull(this.rowId);
            this.columns[ordinal].putBoolean(this.rowId, value);
        }

        public void setByte(int ordinal, byte value) {
            assert (!this.columns[ordinal].isConstant);
            this.columns[ordinal].putNotNull(this.rowId);
            this.columns[ordinal].putByte(this.rowId, value);
        }

        public void setShort(int ordinal, short value) {
            assert (!this.columns[ordinal].isConstant);
            this.columns[ordinal].putNotNull(this.rowId);
            this.columns[ordinal].putShort(this.rowId, value);
        }

        public void setInt(int ordinal, int value) {
            assert (!this.columns[ordinal].isConstant);
            this.columns[ordinal].putNotNull(this.rowId);
            this.columns[ordinal].putInt(this.rowId, value);
        }

        public void setLong(int ordinal, long value) {
            assert (!this.columns[ordinal].isConstant);
            this.columns[ordinal].putNotNull(this.rowId);
            this.columns[ordinal].putLong(this.rowId, value);
        }

        public void setFloat(int ordinal, float value) {
            assert (!this.columns[ordinal].isConstant);
            this.columns[ordinal].putNotNull(this.rowId);
            this.columns[ordinal].putFloat(this.rowId, value);
        }

        public void setDouble(int ordinal, double value) {
            assert (!this.columns[ordinal].isConstant);
            this.columns[ordinal].putNotNull(this.rowId);
            this.columns[ordinal].putDouble(this.rowId, value);
        }

        public void setDecimal(int ordinal, Decimal value, int precision) {
            assert (!this.columns[ordinal].isConstant);
            this.columns[ordinal].putNotNull(this.rowId);
            this.columns[ordinal].putDecimal(this.rowId, value, precision);
        }
    }
}

