/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ContainerLocalityPreferences;
import org.apache.spark.deploy.yarn.LocalityPreferredContainerPlacementStrategy$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001u4Q!\u0001\u0002\u0001\u00051\u00111\u0006T8dC2LG/\u001f)sK\u001a,'O]3e\u0007>tG/Y5oKJ\u0004F.Y2f[\u0016tGo\u0015;sCR,w-\u001f\u0006\u0003\u0007\u0011\tA!_1s]*\u0011QAB\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\"\u0001A\u0007\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g\u0011!!\u0002A!b\u0001\n\u00031\u0012!C:qCJ\\7i\u001c8g\u0007\u0001)\u0012a\u0006\t\u00031ei\u0011AB\u0005\u00035\u0019\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011q\u0001!\u0011!Q\u0001\n]\t!b\u001d9be.\u001cuN\u001c4!\u0011!q\u0002A!b\u0001\n\u0003y\u0012\u0001C=be:\u001cuN\u001c4\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\t\r|gN\u001a\u0006\u0003K!\ta\u0001[1e_>\u0004\u0018BA\u0014#\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"A\u0011\u0006\u0001B\u0001B\u0003%\u0001%A\u0005zCJt7i\u001c8gA!A1\u0006\u0001BC\u0002\u0013\u0005A&\u0001\u0005sKN|WO]2f+\u0005i\u0003C\u0001\u00185\u001b\u0005y#B\u0001\u00192\u0003\u001d\u0011XmY8sINT!AM\u001a\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0004I%\u0011Qg\f\u0002\t%\u0016\u001cx.\u001e:dK\"Aq\u0007\u0001B\u0001B\u0003%Q&A\u0005sKN|WO]2fA!)\u0011\b\u0001C\u0001u\u00051A(\u001b8jiz\"BaO\u001f?\u007fA\u0011A\bA\u0007\u0002\u0005!)A\u0003\u000fa\u0001/!)a\u0004\u000fa\u0001A!)1\u0006\u000fa\u0001[!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0015!D\"Q+N{\u0006+\u0012*`)\u0006\u001b6*F\u0001D!\tqA)\u0003\u0002F\u001f\t\u0019\u0011J\u001c;\t\r\u001d\u0003\u0001\u0015!\u0003D\u00039\u0019\u0005+V*`!\u0016\u0013v\fV!T\u0017\u0002BQ!\u0013\u0001\u0005\u0002)\u000bQ\u0004\\8dC2LG/_(g%\u0016\fX/Z:uK\u0012\u001cuN\u001c;bS:,'o\u001d\u000b\u0006\u0017F\u001bV+\u0019\t\u0004\u001d1s\u0015BA'\u0010\u0005\u0015\t%O]1z!\tat*\u0003\u0002Q\u0005\ta2i\u001c8uC&tWM\u001d'pG\u0006d\u0017\u000e^=Qe\u00164WM]3oG\u0016\u001c\b\"\u0002*I\u0001\u0004\u0019\u0015\u0001\u00048v[\u000e{g\u000e^1j]\u0016\u0014\b\"\u0002+I\u0001\u0004\u0019\u0015!\u00068v[2{7-\u00197jif\fu/\u0019:f)\u0006\u001c8n\u001d\u0005\u0006-\"\u0003\raV\u0001\u0015Q>\u001cH\u000fV8M_\u000e\fG\u000eV1tW\u000e{WO\u001c;\u0011\ta[fl\u0011\b\u0003\u001deK!AW\b\u0002\rA\u0013X\rZ3g\u0013\taVLA\u0002NCBT!AW\b\u0011\u0005a{\u0016B\u00011^\u0005\u0019\u0019FO]5oO\")!\r\u0013a\u0001G\u0006a\u0012\r\u001c7pG\u0006$X\r\u001a%pgR$vnQ8oi\u0006Lg.\u001a:t\u001b\u0006\u0004\b\u0003\u00023j=.l\u0011!\u001a\u0006\u0003M\u001e\fq!\\;uC\ndWM\u0003\u0002i\u001f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005),'a\u0002%bg\"l\u0015\r\u001d\t\u0004I2t\u0017BA7f\u0005\r\u0019V\r\u001e\t\u0003]=L!\u0001]\u0018\u0003\u0017\r{g\u000e^1j]\u0016\u0014\u0018\n\u001a\u0005\u0006e\u0002!Ia]\u0001\u0014]VlW\t_3dkR|'o\u001d)f]\u0012Lgn\u001a\u000b\u0003\u0007RDQ!^9A\u0002\r\u000bqB\\;n)\u0006\u001c8n\u001d)f]\u0012Lgn\u001a\u0005\u0006o\u0002!I\u0001_\u0001\u001dKb\u0004Xm\u0019;fI\"{7\u000f\u001e+p\u0007>tG/Y5oKJ\u001cu.\u001e8u)\u00119\u0016p\u001f?\t\u000bi4\b\u0019A\"\u0002%1|7-\u00197jif\fu/\u0019:f)\u0006\u001c8n\u001d\u0005\u0006-Z\u0004\ra\u0016\u0005\u0006EZ\u0004\ra\u0019")
public class LocalityPreferredContainerPlacementStrategy {
    private final SparkConf sparkConf;
    private final Configuration yarnConf;
    private final Resource resource;
    private final int CPUS_PER_TASK;

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public Configuration yarnConf() {
        return this.yarnConf;
    }

    public Resource resource() {
        return this.resource;
    }

    private int CPUS_PER_TASK() {
        return this.CPUS_PER_TASK;
    }

    public ContainerLocalityPreferences[] localityOfRequestedContainers(int numContainer, int numLocalityAwareTasks, Map<String, Object> hostToLocalTaskCount, HashMap<String, Set<ContainerId>> allocatedHostToContainersMap) {
        Map<String, Object> updatedHostToContainerCount = this.expectedHostToContainerCount(numLocalityAwareTasks, hostToLocalTaskCount, allocatedHostToContainersMap);
        int updatedLocalityAwareContainerNum = BoxesRunTime.unboxToInt((Object)updatedHostToContainerCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int requiredLocalityFreeContainerNum = package$.MODULE$.max(0, numContainer - updatedLocalityAwareContainerNum);
        int requiredLocalityAwareContainerNum = numContainer - requiredLocalityFreeContainerNum;
        ArrayBuffer containerLocalityPreferences = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (requiredLocalityFreeContainerNum > 0) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), requiredLocalityFreeContainerNum).foreach((Function1)new Serializable(this, containerLocalityPreferences){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer containerLocalityPreferences$1;

                public final ArrayBuffer<ContainerLocalityPreferences> apply(int i) {
                    return this.containerLocalityPreferences$1.$plus$eq((Object)new ContainerLocalityPreferences(null, null));
                }
                {
                    this.containerLocalityPreferences$1 = containerLocalityPreferences$1;
                }
            });
        }
        if (requiredLocalityAwareContainerNum > 0) {
            int largestRatio = BoxesRunTime.unboxToInt((Object)updatedHostToContainerCount.values().max((Ordering)Ordering.Int$.MODULE$));
            ObjectRef preferredLocalityRatio = new ObjectRef((Object)updatedHostToContainerCount.mapValues((Function1)new Serializable(this, requiredLocalityAwareContainerNum, largestRatio){
                public static final long serialVersionUID = 0L;
                private final int requiredLocalityAwareContainerNum$1;
                private final int largestRatio$1;

                public final int apply(int ratio) {
                    return this.apply$mcII$sp(ratio);
                }

                public int apply$mcII$sp(int ratio) {
                    double adjustedRatio = (double)ratio * (double)this.requiredLocalityAwareContainerNum$1 / (double)this.largestRatio$1;
                    return (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(adjustedRatio));
                }
                {
                    this.requiredLocalityAwareContainerNum$1 = requiredLocalityAwareContainerNum$1;
                    this.largestRatio$1 = largestRatio$1;
                }
            }));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), requiredLocalityAwareContainerNum).foreach$mVc$sp((Function1)new Serializable(this, containerLocalityPreferences, preferredLocalityRatio){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LocalityPreferredContainerPlacementStrategy $outer;
                private final ArrayBuffer containerLocalityPreferences$1;
                private final ObjectRef preferredLocalityRatio$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    String[] hosts = (String[])((MapLike)((Map)this.preferredLocalityRatio$1.elem).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, Object> x$1) {
                            return x$1._2$mcI$sp() > 0;
                        }
                    })).keys().toArray(ClassTag$.MODULE$.apply(String.class));
                    scala.collection.immutable.Set racks = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])hosts).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$localityOfRequestedContainers$1 $outer;

                        public final String apply(String h) {
                            return RackResolver.resolve((Configuration)this.$outer.org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$anonfun$$$outer().yarnConf(), (String)h).getNetworkLocation();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
                    this.containerLocalityPreferences$1.$plus$eq((Object)new ContainerLocalityPreferences(hosts, (String[])racks.toArray(ClassTag$.MODULE$.apply(String.class))));
                    this.preferredLocalityRatio$1.elem = ((Map)this.preferredLocalityRatio$1.elem).mapValues((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(int x$2) {
                            return this.apply$mcII$sp(x$2);
                        }

                        public int apply$mcII$sp(int x$2) {
                            return x$2 - 1;
                        }
                    });
                }

                public /* synthetic */ LocalityPreferredContainerPlacementStrategy org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.containerLocalityPreferences$1 = containerLocalityPreferences$1;
                    this.preferredLocalityRatio$1 = preferredLocalityRatio$1;
                }
            });
        }
        return (ContainerLocalityPreferences[])containerLocalityPreferences.toArray(ClassTag$.MODULE$.apply(ContainerLocalityPreferences.class));
    }

    public int org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$numExecutorsPending(int numTasksPending) {
        int coresPerExecutor = this.resource().getVirtualCores();
        return (numTasksPending * this.CPUS_PER_TASK() + coresPerExecutor - 1) / coresPerExecutor;
    }

    private Map<String, Object> expectedHostToContainerCount(int localityAwareTasks, Map<String, Object> hostToLocalTaskCount, HashMap<String, Set<ContainerId>> allocatedHostToContainersMap) {
        int totalLocalTaskNum = BoxesRunTime.unboxToInt((Object)hostToLocalTaskCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        return (Map)hostToLocalTaskCount.map((Function1)new Serializable(this, localityAwareTasks, allocatedHostToContainersMap, totalLocalTaskNum){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalityPreferredContainerPlacementStrategy $outer;
            private final int localityAwareTasks$1;
            private final HashMap allocatedHostToContainersMap$1;
            private final int totalLocalTaskNum$1;

            public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String host = (String)tuple2._1();
                    int count = tuple2._2$mcI$sp();
                    double expectedCount = (double)count * (double)this.$outer.org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$numExecutorsPending(this.localityAwareTasks$1) / (double)this.totalLocalTaskNum$1;
                    int existedCount = BoxesRunTime.unboxToInt((Object)this.allocatedHostToContainersMap$1.get((Object)host).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Set<ContainerId> x$3) {
                            return x$3.size();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    }));
                    Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.max(0, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(expectedCount - (double)existedCount)))));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.localityAwareTasks$1 = localityAwareTasks$1;
                this.allocatedHostToContainersMap$1 = allocatedHostToContainersMap$1;
                this.totalLocalTaskNum$1 = totalLocalTaskNum$1;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public LocalityPreferredContainerPlacementStrategy(SparkConf sparkConf, Configuration yarnConf, Resource resource) {
        this.sparkConf = sparkConf;
        this.yarnConf = yarnConf;
        this.resource = resource;
        this.CPUS_PER_TASK = sparkConf.getInt("spark.task.cpus", 1);
    }
}

