/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.extensions;

import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.sftp.client.RawSftpClient;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.extensions.CheckFileHandleExtension;
import org.apache.sshd.sftp.client.extensions.CheckFileNameExtension;
import org.apache.sshd.sftp.client.extensions.CopyDataExtension;
import org.apache.sshd.sftp.client.extensions.CopyFileExtension;
import org.apache.sshd.sftp.client.extensions.MD5FileExtension;
import org.apache.sshd.sftp.client.extensions.MD5HandleExtension;
import org.apache.sshd.sftp.client.extensions.SftpClientExtension;
import org.apache.sshd.sftp.client.extensions.SftpClientExtensionFactory;
import org.apache.sshd.sftp.client.extensions.SpaceAvailableExtension;
import org.apache.sshd.sftp.client.extensions.helpers.CheckFileHandleExtensionImpl;
import org.apache.sshd.sftp.client.extensions.helpers.CheckFileNameExtensionImpl;
import org.apache.sshd.sftp.client.extensions.helpers.CopyDataExtensionImpl;
import org.apache.sshd.sftp.client.extensions.helpers.CopyFileExtensionImpl;
import org.apache.sshd.sftp.client.extensions.helpers.MD5FileExtensionImpl;
import org.apache.sshd.sftp.client.extensions.helpers.MD5HandleExtensionImpl;
import org.apache.sshd.sftp.client.extensions.helpers.SpaceAvailableExtensionImpl;
import org.apache.sshd.sftp.client.extensions.openssh.OpenSSHFsyncExtension;
import org.apache.sshd.sftp.client.extensions.openssh.OpenSSHLimitsExtension;
import org.apache.sshd.sftp.client.extensions.openssh.OpenSSHPosixRenameExtension;
import org.apache.sshd.sftp.client.extensions.openssh.OpenSSHStatHandleExtension;
import org.apache.sshd.sftp.client.extensions.openssh.OpenSSHStatPathExtension;
import org.apache.sshd.sftp.client.extensions.openssh.helpers.OpenSSHFsyncExtensionImpl;
import org.apache.sshd.sftp.client.extensions.openssh.helpers.OpenSSHLimitsExtensionImpl;
import org.apache.sshd.sftp.client.extensions.openssh.helpers.OpenSSHPosixRenameExtensionImpl;
import org.apache.sshd.sftp.client.extensions.openssh.helpers.OpenSSHStatHandleExtensionImpl;
import org.apache.sshd.sftp.client.extensions.openssh.helpers.OpenSSHStatPathExtensionImpl;
import org.apache.sshd.sftp.common.extensions.ParserUtils;

public enum BuiltinSftpClientExtensions implements SftpClientExtensionFactory
{
    COPY_FILE("copy-file", CopyFileExtension.class){

        @Override
        public CopyFileExtension create(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions, Map<String, ?> parsed) {
            return new CopyFileExtensionImpl(client, raw, ParserUtils.supportedExtensions(parsed));
        }
    }
    ,
    COPY_DATA("copy-data", CopyDataExtension.class){

        @Override
        public CopyDataExtension create(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions, Map<String, ?> parsed) {
            return new CopyDataExtensionImpl(client, raw, ParserUtils.supportedExtensions(parsed));
        }
    }
    ,
    MD5_FILE("md5-hash", MD5FileExtension.class){

        @Override
        public MD5FileExtension create(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions, Map<String, ?> parsed) {
            return new MD5FileExtensionImpl(client, raw, ParserUtils.supportedExtensions(parsed));
        }
    }
    ,
    MD5_HANDLE("md5-hash-handle", MD5HandleExtension.class){

        @Override
        public MD5HandleExtension create(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions, Map<String, ?> parsed) {
            return new MD5HandleExtensionImpl(client, raw, ParserUtils.supportedExtensions(parsed));
        }
    }
    ,
    CHECK_FILE_NAME("check-file-name", CheckFileNameExtension.class){

        @Override
        public CheckFileNameExtension create(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions, Map<String, ?> parsed) {
            return new CheckFileNameExtensionImpl(client, raw, ParserUtils.supportedExtensions(parsed));
        }
    }
    ,
    CHECK_FILE_HANDLE("check-file-handle", CheckFileHandleExtension.class){

        @Override
        public CheckFileHandleExtension create(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions, Map<String, ?> parsed) {
            return new CheckFileHandleExtensionImpl(client, raw, ParserUtils.supportedExtensions(parsed));
        }
    }
    ,
    SPACE_AVAILABLE("space-available", SpaceAvailableExtension.class){

        @Override
        public SpaceAvailableExtension create(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions, Map<String, ?> parsed) {
            return new SpaceAvailableExtensionImpl(client, raw, ParserUtils.supportedExtensions(parsed));
        }
    }
    ,
    OPENSSH_FSYNC("fsync@openssh.com", OpenSSHFsyncExtension.class){

        @Override
        public OpenSSHFsyncExtension create(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions, Map<String, ?> parsed) {
            return new OpenSSHFsyncExtensionImpl(client, raw, extensions);
        }
    }
    ,
    OPENSSH_STAT_HANDLE("fstatvfs@openssh.com", OpenSSHStatHandleExtension.class){

        @Override
        public OpenSSHStatHandleExtension create(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions, Map<String, ?> parsed) {
            return new OpenSSHStatHandleExtensionImpl(client, raw, extensions);
        }
    }
    ,
    OPENSSH_STAT_PATH("statvfs@openssh.com", OpenSSHStatPathExtension.class){

        @Override
        public OpenSSHStatPathExtension create(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions, Map<String, ?> parsed) {
            return new OpenSSHStatPathExtensionImpl(client, raw, extensions);
        }
    }
    ,
    OPENSSH_POSIX_RENAME("posix-rename@openssh.com", OpenSSHPosixRenameExtension.class){

        @Override
        public OpenSSHPosixRenameExtension create(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions, Map<String, ?> parsed) {
            return new OpenSSHPosixRenameExtensionImpl(client, raw, extensions);
        }
    }
    ,
    OPENSSH_LIMITS("limits@openssh.com", OpenSSHLimitsExtension.class){

        @Override
        public OpenSSHLimitsExtension create(SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions, Map<String, ?> parsed) {
            return new OpenSSHLimitsExtensionImpl(client, raw, extensions);
        }
    };

    public static final Set<BuiltinSftpClientExtensions> VALUES;
    private final String name;
    private final Class<? extends SftpClientExtension> type;

    private BuiltinSftpClientExtensions(String name, Class<? extends SftpClientExtension> type) {
        this.name = name;
        this.type = type;
    }

    public final String getName() {
        return this.name;
    }

    public final Class<? extends SftpClientExtension> getType() {
        return this.type;
    }

    public static BuiltinSftpClientExtensions fromName(String n) {
        return (BuiltinSftpClientExtensions)NamedResource.findByName((String)n, (Comparator)String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinSftpClientExtensions fromInstance(Object o) {
        return BuiltinSftpClientExtensions.fromType(o == null ? null : o.getClass());
    }

    public static BuiltinSftpClientExtensions fromType(Class<?> type) {
        if (type == null || !SftpClientExtension.class.isAssignableFrom(type)) {
            return null;
        }
        if (SftpClientExtension.class == type) {
            return null;
        }
        for (BuiltinSftpClientExtensions v : VALUES) {
            Class<? extends SftpClientExtension> vt = v.getType();
            if (!vt.isAssignableFrom(type)) continue;
            return v;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinSftpClientExtensions.class));
    }
}

