/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.JsonHelper;
import org.apache.tajo.algebra.JsonSerializable;
import org.apache.tajo.algebra.NamedExpr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.UnaryOperator;
import org.apache.tajo.util.TUtil;

public class Aggregation
extends UnaryOperator {
    @Expose
    @SerializedName(value="Targets")
    private NamedExpr[] namedExprs;
    @Expose
    @SerializedName(value="Groups")
    private GroupElement[] groups;

    public Aggregation() {
        super(OpType.Aggregation);
    }

    public NamedExpr[] getTargets() {
        return this.namedExprs;
    }

    public void setTargets(NamedExpr[] namedExprs) {
        this.namedExprs = namedExprs;
    }

    public void setGroups(GroupElement[] groups) {
        this.groups = groups;
    }

    public boolean isEmptyGrouping() {
        return this.groups == null || this.groups.length == 0;
    }

    public GroupElement[] getGroupSet() {
        return this.groups;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Objects.hashCode((Object[])this.namedExprs), Objects.hashCode((Object[])this.groups), this.getChild()});
    }

    @Override
    public boolean equalsTo(Expr expr) {
        Aggregation another = (Aggregation)expr;
        boolean a = TUtil.checkEquals((Object[])this.groups, (Object[])another.groups);
        boolean b = TUtil.checkEquals((Object[])this.namedExprs, (Object[])another.namedExprs);
        return a && b;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        Aggregation aggregation = (Aggregation)super.clone();
        if (this.namedExprs != null) {
            aggregation.namedExprs = new NamedExpr[this.namedExprs.length];
            for (i = 0; i < this.namedExprs.length; ++i) {
                aggregation.namedExprs[i] = this.namedExprs[i].clone();
            }
        }
        if (this.groups != null) {
            aggregation.groups = new GroupElement[this.groups.length];
            for (i = 0; i < this.groups.length; ++i) {
                aggregation.groups[i] = (GroupElement)this.groups[i].clone();
            }
        }
        return aggregation;
    }

    public static enum GroupType {
        OrdinaryGroup(""),
        Cube("Cube"),
        Rollup("Rollup"),
        EmptySet("()");

        String displayName;

        private GroupType(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static class GroupElement
    implements JsonSerializable,
    Cloneable {
        @Expose
        @SerializedName(value="GroupType")
        private GroupType group_type;
        @Expose
        @SerializedName(value="Dimensions")
        private Expr[] grouping_sets;

        public GroupElement(GroupType groupType, Expr[] grouping_sets) {
            this.group_type = groupType;
            this.grouping_sets = grouping_sets;
        }

        public GroupType getType() {
            return this.group_type;
        }

        public Expr[] getGroupingSets() {
            return this.grouping_sets;
        }

        public String toString() {
            return this.toJson();
        }

        @Override
        public String toJson() {
            return JsonHelper.toJson(this);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group_type, Objects.hashCode((Object[])this.grouping_sets)});
        }

        public boolean equals(Object obj) {
            if (obj instanceof GroupElement) {
                GroupElement other = (GroupElement)obj;
                return this.group_type.equals((Object)other.group_type) && TUtil.checkEquals((Object[])this.grouping_sets, (Object[])other.grouping_sets);
            }
            return false;
        }

        public Object clone() throws CloneNotSupportedException {
            GroupElement element = (GroupElement)super.clone();
            element.group_type = this.group_type;
            if (element.grouping_sets != null) {
                element.grouping_sets = new Expr[this.grouping_sets.length];
                for (int i = 0; i < this.grouping_sets.length; ++i) {
                    element.grouping_sets[i] = (Expr)this.grouping_sets[i].clone();
                }
            }
            return element;
        }
    }
}

