/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import org.apache.tajo.algebra.AlterTableOpType;
import org.apache.tajo.algebra.ColumnDefinition;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.util.TUtil;

public class AlterTable
extends Expr {
    @Expose
    @SerializedName(value="OldTableName")
    private String tableName;
    @Expose
    @SerializedName(value="NewTableName")
    private String newTableName;
    @Expose
    @SerializedName(value="OldColumnName")
    private String columnName;
    @Expose
    @SerializedName(value="NewColumnName")
    private String newColumnName;
    @Expose
    @SerializedName(value="NewColumnDef")
    private ColumnDefinition addNewColumn;
    @Expose
    @SerializedName(value="AlterTableType")
    private AlterTableOpType alterTableOpType;
    @Expose
    @SerializedName(value="TableProperties")
    private Map<String, String> params;
    @Expose
    @SerializedName(value="Columns")
    ColumnReferenceExpr[] columns;
    @Expose
    @SerializedName(value="Values")
    private Expr[] values;
    @Expose
    @SerializedName(value="location")
    private String location;
    @Expose
    @SerializedName(value="IsPurge")
    private boolean purge;
    @Expose
    @SerializedName(value="IfNotExists")
    private boolean ifNotExists;
    @Expose
    @SerializedName(value="IfExists")
    private boolean ifExists;

    public AlterTable(String tableName) {
        super(OpType.AlterTable);
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public void setNewTableName(String newTableName) {
        this.newTableName = newTableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public void setNewColumnName(String newColumnName) {
        this.newColumnName = newColumnName;
    }

    public ColumnDefinition getAddNewColumn() {
        return this.addNewColumn;
    }

    public void setAddNewColumn(ColumnDefinition addNewColumn) {
        this.addNewColumn = addNewColumn;
    }

    public AlterTableOpType getAlterTableOpType() {
        return this.alterTableOpType;
    }

    public void setAlterTableOpType(AlterTableOpType alterTableOpType) {
        this.alterTableOpType = alterTableOpType;
    }

    public ColumnReferenceExpr[] getColumns() {
        return this.columns;
    }

    public void setColumns(ColumnReferenceExpr[] columns) {
        this.columns = columns;
    }

    public Expr[] getValues() {
        return this.values;
    }

    public void setValues(Expr[] values) {
        this.values = values;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean hasParams() {
        return this.params != null;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public boolean isPurge() {
        return this.purge;
    }

    public void setPurge(boolean purge) {
        this.purge = purge;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tableName, this.newTableName, this.columnName, this.newColumnName, this.addNewColumn, this.alterTableOpType, this.columns, this.values, this.location, this.params, this.purge, this.ifNotExists, this.ifExists});
    }

    @Override
    boolean equalsTo(Expr expr) {
        AlterTable another = (AlterTable)expr;
        return this.tableName.equals(another.tableName) && TUtil.checkEquals((Object)this.newTableName, (Object)another.newTableName) && TUtil.checkEquals((Object)this.columnName, (Object)another.columnName) && TUtil.checkEquals((Object)this.newColumnName, (Object)another.newColumnName) && TUtil.checkEquals((Object)this.addNewColumn, (Object)another.addNewColumn) && TUtil.checkEquals((Object)((Object)this.alterTableOpType), (Object)((Object)another.alterTableOpType)) && TUtil.checkEquals((Object[])this.columns, (Object[])another.columns) && TUtil.checkEquals((Object[])this.values, (Object[])another.values) && TUtil.checkEquals((Object)this.location, (Object)another.location) && TUtil.checkEquals(this.params, another.params) && TUtil.checkEquals((Object)this.purge, (Object)another.purge) && TUtil.checkEquals((Object)this.ifNotExists, (Object)another.ifNotExists) && TUtil.checkEquals((Object)this.ifExists, (Object)another.ifExists);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AlterTable alter = (AlterTable)super.clone();
        alter.tableName = this.tableName;
        alter.newTableName = this.newTableName;
        alter.columnName = this.columnName;
        alter.newColumnName = this.newColumnName;
        if (this.addNewColumn != null) {
            alter.addNewColumn = (ColumnDefinition)this.addNewColumn.clone();
        }
        alter.alterTableOpType = this.alterTableOpType;
        alter.columns = this.columns;
        alter.values = this.values;
        alter.location = this.location;
        if (this.params != null) {
            alter.params = new HashMap<String, String>(this.params);
        }
        alter.purge = this.purge;
        alter.ifNotExists = this.ifNotExists;
        alter.ifExists = this.ifExists;
        return alter;
    }
}

