/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.AlterTablespaceSetType;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.util.TUtil;

public class AlterTablespace
extends Expr {
    @Expose
    @SerializedName(value="TablespaceName")
    private String tablespaceName;
    @Expose
    @SerializedName(value="AlterTablespaceType")
    private AlterTablespaceSetType setType;
    @Expose
    @SerializedName(value="URI")
    private String uri;

    public AlterTablespace(String tablespaceName) {
        super(OpType.AlterTablespace);
        this.tablespaceName = tablespaceName;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public AlterTablespaceSetType getSetType() {
        return this.setType;
    }

    public String getLocation() {
        return this.uri;
    }

    public void setLocation(String uri) {
        this.setType = AlterTablespaceSetType.LOCATION;
        this.uri = uri;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tablespaceName, this.setType});
    }

    @Override
    boolean equalsTo(Expr expr) {
        AlterTablespace another = (AlterTablespace)expr;
        return this.tablespaceName.equals(another.tablespaceName) && TUtil.checkEquals((Object)((Object)this.setType), (Object)((Object)another.setType)) && TUtil.checkEquals((Object)this.uri, (Object)another.uri);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AlterTablespace alter = (AlterTablespace)super.clone();
        alter.setType = this.setType;
        alter.tablespaceName = this.tablespaceName;
        alter.uri = this.uri;
        return alter;
    }
}

