/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;

public class BetweenPredicate
extends Expr {
    @Expose
    @SerializedName(value="IsNot")
    private boolean not;
    @Expose
    @SerializedName(value="IsSymmetric")
    private boolean symmetric = false;
    @Expose
    @SerializedName(value="Predicand")
    private Expr predicand;
    @Expose
    @SerializedName(value="Begin")
    private Expr begin;
    @Expose
    @SerializedName(value="End")
    private Expr end;

    public BetweenPredicate(boolean not, boolean symmetric, Expr predicand, Expr begin, Expr end) {
        super(OpType.Between);
        this.not = not;
        this.symmetric = symmetric;
        this.predicand = predicand;
        this.begin = begin;
        this.end = end;
    }

    public boolean isNot() {
        return this.not;
    }

    public boolean isSymmetric() {
        return this.symmetric;
    }

    public Expr predicand() {
        return this.predicand;
    }

    public Expr begin() {
        return this.begin;
    }

    public Expr end() {
        return this.end;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.not, this.symmetric, this.predicand, this.begin, this.end});
    }

    @Override
    boolean equalsTo(Expr expr) {
        BetweenPredicate another = (BetweenPredicate)expr;
        return this.symmetric == another.symmetric && this.predicand.equals(another.predicand) && this.begin.equals(another.begin) && this.end.equals(another.end);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BetweenPredicate between = (BetweenPredicate)super.clone();
        between.not = this.not;
        between.symmetric = this.symmetric;
        between.predicand = (Expr)this.predicand.clone();
        between.begin = (Expr)this.begin.clone();
        between.end = (Expr)this.end.clone();
        return between;
    }
}

