/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;

public class BinaryOperator
extends Expr {
    @Expose
    @SerializedName(value="LeftExpr")
    protected Expr left;
    @Expose
    @SerializedName(value="RightExpr")
    protected Expr right;

    BinaryOperator(OpType opType) {
        super(opType);
    }

    public BinaryOperator(OpType type, Expr left, Expr right) {
        super(type);
        this.left = left;
        this.right = right;
    }

    public <T extends Expr> T getLeft() {
        return (T)this.left;
    }

    public void setLeft(Expr left) {
        this.left = left;
    }

    public <T extends Expr> T getRight() {
        return (T)this.right;
    }

    public void setRight(Expr right) {
        this.right = right;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.opType, this.left, this.right});
    }

    @Override
    boolean equalsTo(Expr expr) {
        return true;
    }

    @Override
    public String toString() {
        return this.left.toString() + " " + this.opType.toString() + " " + this.right.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BinaryOperator binaryOperator = (BinaryOperator)super.clone();
        binaryOperator.left = (Expr)this.left.clone();
        binaryOperator.right = (Expr)this.right.clone();
        return binaryOperator;
    }
}

