/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.JsonHelper;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.util.TUtil;

public class CaseWhenPredicate
extends Expr {
    @Expose
    @SerializedName(value="WhenExprs")
    private List<WhenExpr> whens = new ArrayList<WhenExpr>();
    @Expose
    @SerializedName(value="ElseExpr")
    private Expr elseResult;

    public CaseWhenPredicate() {
        super(OpType.CaseWhen);
    }

    public void addWhen(Expr condition, Expr result) {
        this.whens.add(new WhenExpr(condition, result));
    }

    public Collection<WhenExpr> getWhens() {
        return this.whens;
    }

    public void setElseResult(Expr elseResult) {
        this.elseResult = elseResult;
    }

    public Expr getElseResult() {
        return this.elseResult;
    }

    public boolean hasElseResult() {
        return this.elseResult != null;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.whens, this.elseResult});
    }

    @Override
    boolean equalsTo(Expr expr) {
        CaseWhenPredicate another = (CaseWhenPredicate)expr;
        return this.whens.equals(another.whens) && TUtil.checkEquals((Object)this.elseResult, (Object)another.elseResult);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CaseWhenPredicate caseWhen = (CaseWhenPredicate)super.clone();
        caseWhen.whens = new ArrayList<WhenExpr>();
        for (int i = 0; i < this.whens.size(); ++i) {
            caseWhen.whens.add((WhenExpr)this.whens.get(i).clone());
        }
        caseWhen.elseResult = this.elseResult != null ? (Expr)this.elseResult.clone() : null;
        return caseWhen;
    }

    @Override
    public String toJson() {
        return JsonHelper.toJson(this);
    }

    public static class WhenExpr
    implements Cloneable {
        @Expose
        @SerializedName(value="Condition")
        Expr condition;
        @Expose
        @SerializedName(value="Result")
        Expr result;

        public WhenExpr(Expr condition, Expr result) {
            this.condition = condition;
            this.result = result;
        }

        public void setCondition(Expr condition) {
            this.condition = condition;
        }

        public Expr getCondition() {
            return this.condition;
        }

        public void setResult(Expr result) {
            this.result = result;
        }

        public Expr getResult() {
            return this.result;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.condition, this.result});
        }

        public boolean equals(Object obj) {
            if (obj instanceof WhenExpr) {
                WhenExpr another = (WhenExpr)obj;
                return TUtil.checkEquals((Object)this.condition, (Object)another.condition) && TUtil.checkEquals((Object)this.result, (Object)another.result);
            }
            return false;
        }

        public Object clone() throws CloneNotSupportedException {
            WhenExpr when = (WhenExpr)super.clone();
            when.condition = (Expr)this.condition.clone();
            when.result = (Expr)this.result.clone();
            return when;
        }
    }
}

