/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.DataTypeExpr;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.UnaryOperator;

public class CastExpr
extends UnaryOperator {
    @Expose
    @SerializedName(value="CastType")
    private DataTypeExpr target;

    public CastExpr(Expr operand, DataTypeExpr target) {
        super(OpType.Cast);
        this.target = target;
        this.setChild(operand);
    }

    public Expr getOperand() {
        return this.getChild();
    }

    public DataTypeExpr getTarget() {
        return this.target;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.target, this.getChild()});
    }

    @Override
    boolean equalsTo(Expr expr) {
        CastExpr another = (CastExpr)expr;
        return this.target.equals(another.target);
    }
}

