/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.DataTypeExpr;
import org.apache.tajo.algebra.Expr;

public class ColumnDefinition
extends DataTypeExpr {
    @Expose
    @SerializedName(value="ColumnDefName")
    String columnName;

    public ColumnDefinition(String columnName, String dataType) {
        super(dataType);
        this.columnName = columnName;
    }

    public ColumnDefinition(String columnName, DataTypeExpr dataType) {
        super(dataType.getTypeName());
        this.columnName = columnName;
        if (dataType.hasLengthOrPrecision()) {
            this.setLengthOrPrecision(dataType.lengthOrPrecision);
            if (dataType.hasScale()) {
                this.setScale(dataType.scale);
            }
        }
        if (dataType.isRecordType()) {
            this.recordType = dataType.recordType;
        }
        if (dataType.isMapType()) {
            this.mapType = dataType.mapType;
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return hash * 89 * this.columnName.hashCode();
    }

    @Override
    public boolean equalsTo(Expr expr) {
        if (expr instanceof ColumnDefinition) {
            ColumnDefinition another = (ColumnDefinition)expr;
            return this.columnName.equals(another.columnName) && super.equalsTo(another);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ColumnDefinition column = (ColumnDefinition)super.clone();
        column.columnName = this.columnName;
        return column;
    }
}

