/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.util.TUtil;

public class ColumnReferenceExpr
extends Expr {
    @Expose
    @SerializedName(value="Qualifier")
    private String qualifier;
    @Expose
    @SerializedName(value="ColumnName")
    private String name;

    public ColumnReferenceExpr(String referenceName) {
        super(OpType.Column);
        this.setName(referenceName);
    }

    public ColumnReferenceExpr(String qualifier, String columnName) {
        super(OpType.Column);
        this.qualifier = qualifier;
        this.name = columnName;
    }

    public boolean hasQualifier() {
        return this.qualifier != null;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String qualifiedName) {
        String[] parts = qualifiedName.split("\\.");
        if (parts.length > 1) {
            this.qualifier = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
            this.name = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1, qualifiedName.length());
        } else {
            this.name = parts[0];
        }
    }

    public String getCanonicalName() {
        if (this.qualifier != null) {
            return this.qualifier + "." + this.name;
        }
        return this.name;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.qualifier});
    }

    @Override
    public boolean equalsTo(Expr expr) {
        ColumnReferenceExpr another = (ColumnReferenceExpr)expr;
        return this.name.equals(another.name) && TUtil.checkEquals((Object)this.qualifier, (Object)another.qualifier);
    }

    @Override
    public String toString() {
        return this.qualifier != null ? this.qualifier + "." + this.name : this.name;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ColumnReferenceExpr column = (ColumnReferenceExpr)super.clone();
        column.qualifier = this.qualifier;
        column.name = this.name;
        return column;
    }
}

