/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.util.TUtil;

public class CreateDatabase
extends Expr {
    @Expose
    @SerializedName(value="DatabaseName")
    private String databaseName;
    @Expose
    @SerializedName(value="TablespaceName")
    private String tablespaceName;
    @Expose
    @SerializedName(value="IfNotExists")
    private boolean ifNotExists;
    @Expose
    @SerializedName(value="Properties")
    private Map<String, String> params;

    public CreateDatabase(String databaseName, String tablespaceName, boolean ifNotExists) {
        super(OpType.CreateDatabase);
        this.databaseName = databaseName;
        this.tablespaceName = tablespaceName;
        this.ifNotExists = ifNotExists;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean hasTablespaceName() {
        return this.tablespaceName != null;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public boolean hasParams() {
        return this.params != null;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.databaseName, this.tablespaceName, this.ifNotExists});
    }

    @Override
    boolean equalsTo(Expr expr) {
        CreateDatabase another = (CreateDatabase)expr;
        return this.databaseName.equals(another.databaseName) && TUtil.checkEquals((Object)this.tablespaceName, (Object)another.tablespaceName) && this.ifNotExists == another.ifNotExists;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CreateDatabase createDb = (CreateDatabase)super.clone();
        createDb.databaseName = this.databaseName;
        createDb.tablespaceName = this.tablespaceName;
        createDb.ifNotExists = this.ifNotExists;
        return createDb;
    }
}

