/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.Sort;
import org.apache.tajo.algebra.UnaryOperator;
import org.apache.tajo.util.TUtil;

public class CreateIndex
extends UnaryOperator {
    @Expose
    @SerializedName(value="IsUnique")
    private boolean unique = false;
    @Expose
    @SerializedName(value="IndexName")
    private String indexName;
    @Expose
    @SerializedName(value="SortSpecs")
    private Sort.SortSpec[] sortSpecs;
    @Expose
    @SerializedName(value="Properties")
    private Map<String, String> params;
    @Expose
    @SerializedName(value="IndexMethodSpec")
    private IndexMethodSpec methodSpec;
    private boolean external = false;
    @Expose
    @SerializedName(value="IndexPath")
    private String indexPath;

    public CreateIndex(String indexName, Sort.SortSpec[] sortSpecs) {
        super(OpType.CreateIndex);
        this.indexName = indexName;
        this.sortSpecs = sortSpecs;
        this.methodSpec = new IndexMethodSpec("TWO_LEVEL_BIN_TREE");
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setSortSpecs(Sort.SortSpec[] sortSpecs) {
        this.sortSpecs = sortSpecs;
    }

    public Sort.SortSpec[] getSortSpecs() {
        return this.sortSpecs;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setMethodSpec(IndexMethodSpec methodSpec) {
        this.methodSpec = methodSpec;
    }

    public IndexMethodSpec getMethodSpec() {
        return this.methodSpec;
    }

    public void setIndexPath(String indexPath) {
        this.external = true;
        this.indexPath = indexPath;
    }

    public boolean isExternal() {
        return this.external;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.unique, this.indexName, this.sortSpecs, this.params, this.methodSpec, this.external});
    }

    @Override
    boolean equalsTo(Expr expr) {
        CreateIndex other = (CreateIndex)expr;
        return this.unique == other.unique && this.indexName.equals(other.indexName) && TUtil.checkEquals((Object[])this.sortSpecs, (Object[])other.sortSpecs) && TUtil.checkEquals(this.params, other.params) && this.methodSpec.equals(other.methodSpec) && this.external == other.external;
    }

    public static class IndexMethodSpec {
        @Expose
        @SerializedName(value="IndexMethodName")
        private String name;

        public IndexMethodSpec(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof IndexMethodSpec) {
                IndexMethodSpec other = (IndexMethodSpec)o;
                return this.name.equals(other.name);
            }
            return false;
        }
    }
}

