/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tajo.algebra.ColumnDefinition;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.ValueListExpr;
import org.apache.tajo.json.CommonGsonHelper;
import org.apache.tajo.util.TUtil;

public class CreateTable
extends Expr {
    @Expose
    @SerializedName(value="IsExternal")
    private boolean external = false;
    @Expose
    @SerializedName(value="TableName")
    private String tableName;
    @Expose
    @SerializedName(value="Attributes")
    private ColumnDefinition[] tableElements;
    @Expose
    @SerializedName(value="SpaceName")
    private String spaceName;
    @Expose
    @SerializedName(value="StorageType")
    private String storageType;
    @Expose
    @SerializedName(value="Location")
    private String location;
    @Expose
    @SerializedName(value="SubPlan")
    private Expr subquery;
    @Expose
    @SerializedName(value="Properties")
    private Map<String, String> params;
    @Expose
    @SerializedName(value="PartitionMethodDesc")
    private PartitionMethodDescExpr partition;
    @Expose
    @SerializedName(value="IfNotExists")
    private boolean ifNotExists;
    @Expose
    @SerializedName(value="LikeParentTable")
    private String likeParentTable;
    @Expose
    @SerializedName(value="HasSelfDescSchema")
    private boolean selfDescSchema = false;

    public CreateTable(String tableName, boolean ifNotExists) {
        super(OpType.CreateTable);
        this.tableName = tableName;
        this.ifNotExists = ifNotExists;
    }

    public CreateTable(String tableName, Expr subQuery, boolean ifNotExists) {
        this(tableName, ifNotExists);
        this.subquery = subQuery;
    }

    public void setExternal() {
        this.external = true;
    }

    public boolean isExternal() {
        return this.external;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean hasTableElements() {
        return this.tableElements != null;
    }

    public ColumnDefinition[] getTableElements() {
        return this.tableElements;
    }

    public void setTableElements(ColumnDefinition[] tableElements) {
        this.tableElements = tableElements;
    }

    public boolean hasTableSpaceName() {
        return this.spaceName != null;
    }

    public void setTableSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public String getTableSpaceName() {
        return this.spaceName;
    }

    public boolean hasStorageType() {
        return this.storageType != null;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public boolean hasParams() {
        return this.params != null;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public boolean hasPartition() {
        return this.partition != null;
    }

    public void setPartitionMethod(PartitionMethodDescExpr partition) {
        this.partition = partition;
    }

    public <T extends PartitionMethodDescExpr> T getPartitionMethod() {
        return (T)this.partition;
    }

    public boolean hasSubQuery() {
        return this.subquery != null;
    }

    public void setSubQuery(Expr subquery) {
        this.subquery = subquery;
    }

    public Expr getSubQuery() {
        return this.subquery;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setLikeParentTable(String parentTable) {
        this.likeParentTable = parentTable;
    }

    public String getLikeParentTableName() {
        return this.likeParentTable;
    }

    public void setHasSelfDescSchema() {
        this.selfDescSchema = true;
    }

    public void unsetHasSelfDescSchema() {
        this.selfDescSchema = false;
    }

    public boolean hasSelfDescSchema() {
        return this.selfDescSchema;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.external, this.tableName, Objects.hashCode((Object[])this.tableElements), this.storageType, this.subquery, this.location, this.params, this.partition, this.ifNotExists});
    }

    @Override
    boolean equalsTo(Expr expr) {
        CreateTable another = (CreateTable)expr;
        return this.external == another.external && this.tableName.equals(another.tableName) && TUtil.checkEquals((Object[])this.tableElements, (Object[])another.tableElements) && TUtil.checkEquals((Object)this.storageType, (Object)another.storageType) && TUtil.checkEquals((Object)this.location, (Object)another.location) && TUtil.checkEquals((Object)this.subquery, (Object)another.subquery) && TUtil.checkEquals(this.params, another.params) && TUtil.checkEquals((Object)this.partition, (Object)another.partition) && this.ifNotExists == another.ifNotExists;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CreateTable createTable = (CreateTable)super.clone();
        createTable.external = this.external;
        createTable.tableName = this.tableName;
        if (this.tableElements != null) {
            createTable.tableElements = new ColumnDefinition[this.tableElements.length];
            for (int i = 0; i < this.tableElements.length; ++i) {
                createTable.tableElements[i] = (ColumnDefinition)this.tableElements[i].clone();
            }
        }
        createTable.storageType = this.storageType;
        createTable.location = this.location;
        createTable.subquery = this.subquery;
        if (this.params != null) {
            createTable.params = new HashMap<String, String>(this.params);
        }
        if (this.partition != null) {
            createTable.partition = (PartitionMethodDescExpr)this.partition.clone();
        }
        createTable.ifNotExists = this.ifNotExists;
        return createTable;
    }

    public static class PartitionSpecifier
    implements Cloneable {
        @Expose
        @SerializedName(value="PartitionSpecName")
        private String name;

        public PartitionSpecifier(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PartitionSpecifier) {
                return this.name.equals(((PartitionSpecifier)obj).name);
            }
            return false;
        }

        public Object clone() throws CloneNotSupportedException {
            PartitionSpecifier specifier = (PartitionSpecifier)super.clone();
            specifier.name = this.name;
            return specifier;
        }
    }

    public static class ListPartitionSpecifier
    extends PartitionSpecifier
    implements Cloneable {
        @Expose
        @SerializedName(value="ValueList")
        ValueListExpr valueList;

        public ListPartitionSpecifier(String name, ValueListExpr valueList) {
            super(name);
            this.valueList = valueList;
        }

        public ValueListExpr getValueList() {
            return this.valueList;
        }

        @Override
        public int hashCode() {
            return this.valueList.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListPartitionSpecifier that = (ListPartitionSpecifier)o;
            return this.valueList.equals(that.valueList);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            ListPartitionSpecifier specifier = (ListPartitionSpecifier)super.clone();
            specifier.valueList = (ValueListExpr)this.valueList.clone();
            return specifier;
        }
    }

    public static class RangePartitionSpecifier
    extends PartitionSpecifier
    implements Cloneable {
        @Expose
        @SerializedName(value="End")
        Expr end;
        @Expose
        @SerializedName(value="IsMaxValue")
        boolean maxValue;

        public RangePartitionSpecifier(String name, Expr end) {
            super(name);
            this.end = end;
        }

        public RangePartitionSpecifier(String name) {
            super(name);
            this.maxValue = true;
        }

        public Expr getEnd() {
            return this.end;
        }

        public boolean isEndMaxValue() {
            return this.maxValue;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.end, this.maxValue});
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RangePartitionSpecifier that = (RangePartitionSpecifier)o;
            if (this.maxValue != that.maxValue) {
                return false;
            }
            return this.end.equals(that.end);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            RangePartitionSpecifier specifier = (RangePartitionSpecifier)super.clone();
            if (this.end != null) {
                specifier.end = (Expr)this.end.clone();
            }
            specifier.maxValue = this.maxValue;
            return specifier;
        }
    }

    public static class ColumnPartition
    extends PartitionMethodDescExpr {
        @Expose
        @SerializedName(value="Columns")
        private ColumnDefinition[] columns;
        @Expose
        @SerializedName(value="IsOmitValues")
        private boolean isOmitValues;

        public ColumnPartition(ColumnDefinition[] columns) {
            super(PartitionType.COLUMN);
            this.columns = columns;
        }

        public ColumnDefinition[] getColumns() {
            return this.columns;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])this.columns);
        }

        public boolean equals(Object object) {
            if (object instanceof ColumnPartition) {
                ColumnPartition another = (ColumnPartition)object;
                return this.type == another.type && TUtil.checkEquals((Object[])this.columns, (Object[])another.columns);
            }
            return false;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            ColumnPartition columnPartition = (ColumnPartition)super.clone();
            if (this.columns != null) {
                columnPartition.columns = new ColumnDefinition[this.columns.length];
                for (int i = 0; i < this.columns.length; ++i) {
                    columnPartition.columns[i] = (ColumnDefinition)this.columns[i].clone();
                }
            }
            return columnPartition;
        }
    }

    public static class ListPartition
    extends PartitionMethodDescExpr {
        @Expose
        @SerializedName(value="Columns")
        ColumnReferenceExpr[] columns;
        @Expose
        @SerializedName(value="Specifiers")
        List<ListPartitionSpecifier> specifiers;

        public ListPartition(ColumnReferenceExpr[] columns, List<ListPartitionSpecifier> specifers) {
            super(PartitionType.LIST);
            this.columns = columns;
            this.specifiers = specifers;
        }

        public ColumnReferenceExpr[] getColumns() {
            return this.columns;
        }

        public List<ListPartitionSpecifier> getSpecifiers() {
            return this.specifiers;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{Objects.hashCode((Object[])this.columns), this.specifiers});
        }

        public boolean equals(Object object) {
            if (object instanceof ListPartition) {
                ListPartition another = (ListPartition)object;
                return this.type == another.type && TUtil.checkEquals((Object[])this.columns, (Object[])another.columns) && this.specifiers.equals(another.specifiers);
            }
            return false;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            ListPartition listPartition = (ListPartition)super.clone();
            if (this.columns != null) {
                listPartition.columns = new ColumnReferenceExpr[this.columns.length];
                for (int i = 0; i < this.columns.length; ++i) {
                    listPartition.columns[i] = (ColumnReferenceExpr)this.columns[i].clone();
                }
            }
            if (this.specifiers != null) {
                listPartition.specifiers = new ArrayList<ListPartitionSpecifier>();
                for (ListPartitionSpecifier specifier : this.specifiers) {
                    listPartition.specifiers.add(specifier);
                }
            }
            return listPartition;
        }
    }

    public static class HashPartition
    extends PartitionMethodDescExpr
    implements Cloneable {
        @Expose
        @SerializedName(value="Columns")
        ColumnReferenceExpr[] columns;
        @Expose
        @SerializedName(value="Quantity")
        Expr quantity;
        @Expose
        @SerializedName(value="Specifiers")
        List<PartitionSpecifier> specifiers;

        public HashPartition(ColumnReferenceExpr[] columns, Expr quantity) {
            super(PartitionType.HASH);
            this.columns = columns;
            this.quantity = quantity;
        }

        public HashPartition(ColumnReferenceExpr[] columns, List<PartitionSpecifier> specifier) {
            super(PartitionType.HASH);
            this.columns = columns;
            this.specifiers = specifier;
        }

        public ColumnReferenceExpr[] getColumns() {
            return this.columns;
        }

        public boolean hasQuantifier() {
            return this.quantity != null;
        }

        public Expr getQuantifier() {
            return this.quantity;
        }

        public boolean hasSpecifiers() {
            return this.specifiers != null;
        }

        public List<PartitionSpecifier> getSpecifiers() {
            return this.specifiers;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.columns, this.specifiers});
        }

        public boolean equals(Object object) {
            if (object instanceof HashPartition) {
                HashPartition another = (HashPartition)object;
                return this.type == another.type && TUtil.checkEquals((Object[])this.columns, (Object[])another.columns) && this.specifiers.equals(another.specifiers);
            }
            return false;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            HashPartition hash = (HashPartition)super.clone();
            if (this.columns != null) {
                hash.columns = new ColumnReferenceExpr[this.columns.length];
                for (int i = 0; i < this.columns.length; ++i) {
                    hash.columns[i] = (ColumnReferenceExpr)this.columns[i].clone();
                }
            }
            hash.quantity = this.quantity;
            if (this.specifiers != null) {
                hash.specifiers = new ArrayList<PartitionSpecifier>();
                for (PartitionSpecifier specifier : this.specifiers) {
                    hash.specifiers.add(specifier);
                }
            }
            return hash;
        }
    }

    public static class RangePartition
    extends PartitionMethodDescExpr
    implements Cloneable {
        @Expose
        @SerializedName(value="Columns")
        ColumnReferenceExpr[] columns;
        @Expose
        @SerializedName(value="Specifiers")
        List<RangePartitionSpecifier> specifiers;

        public RangePartition(ColumnReferenceExpr[] columns, List<RangePartitionSpecifier> specifiers) {
            super(PartitionType.RANGE);
            this.columns = columns;
            this.specifiers = specifiers;
        }

        public ColumnReferenceExpr[] getColumns() {
            return this.columns;
        }

        public List<RangePartitionSpecifier> getSpecifiers() {
            return this.specifiers;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, Objects.hashCode((Object[])this.columns), this.specifiers});
        }

        public boolean equals(Object object) {
            if (object instanceof RangePartition) {
                RangePartition another = (RangePartition)object;
                return this.type == another.type && TUtil.checkEquals((Object[])this.columns, (Object[])another.columns) && this.specifiers.equals(another.specifiers);
            }
            return false;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            int i;
            RangePartition range = (RangePartition)super.clone();
            if (this.columns != null) {
                range.columns = new ColumnReferenceExpr[this.columns.length];
                for (i = 0; i < this.columns.length; ++i) {
                    range.columns[i] = (ColumnReferenceExpr)this.columns[i].clone();
                }
            }
            if (this.specifiers != null) {
                range.specifiers = new ArrayList<RangePartitionSpecifier>();
                for (i = 0; i < this.specifiers.size(); ++i) {
                    range.specifiers.add(this.specifiers.get(i));
                }
            }
            return range;
        }
    }

    public static abstract class PartitionMethodDescExpr
    implements Cloneable {
        @Expose
        @SerializedName(value="PartitionType")
        PartitionType type;

        public PartitionMethodDescExpr(PartitionType type) {
            this.type = type;
        }

        public PartitionType getPartitionType() {
            return this.type;
        }

        public Object clone() throws CloneNotSupportedException {
            PartitionMethodDescExpr partition = (PartitionMethodDescExpr)super.clone();
            partition.type = this.type;
            return partition;
        }

        static class JsonSerDer
        implements JsonSerializer<PartitionMethodDescExpr>,
        JsonDeserializer<PartitionMethodDescExpr> {
            JsonSerDer() {
            }

            public PartitionMethodDescExpr deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                PartitionType type = PartitionType.valueOf(CommonGsonHelper.getOrDie((JsonObject)jsonObject, (String)"PartitionType").getAsString());
                switch (type) {
                    case RANGE: {
                        return (PartitionMethodDescExpr)context.deserialize(json, RangePartition.class);
                    }
                    case HASH: {
                        return (PartitionMethodDescExpr)context.deserialize(json, HashPartition.class);
                    }
                    case LIST: {
                        return (PartitionMethodDescExpr)context.deserialize(json, ListPartition.class);
                    }
                    case COLUMN: {
                        return (PartitionMethodDescExpr)context.deserialize(json, ColumnPartition.class);
                    }
                }
                return null;
            }

            public JsonElement serialize(PartitionMethodDescExpr src, Type typeOfSrc, JsonSerializationContext context) {
                switch (src.getPartitionType()) {
                    case RANGE: {
                        return context.serialize((Object)src, RangePartition.class);
                    }
                    case HASH: {
                        return context.serialize((Object)src, HashPartition.class);
                    }
                    case LIST: {
                        return context.serialize((Object)src, ListPartition.class);
                    }
                    case COLUMN: {
                        return context.serialize((Object)src, ColumnPartition.class);
                    }
                }
                return null;
            }
        }
    }

    public static enum PartitionType {
        RANGE,
        HASH,
        LIST,
        COLUMN;

    }
}

