/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.ColumnDefinition;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.JsonHelper;
import org.apache.tajo.algebra.JsonSerializable;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.util.TUtil;

public class DataTypeExpr
extends Expr {
    @Expose
    @SerializedName(value="DataTypeName")
    String typeName;
    @Expose
    @SerializedName(value="LengthOrPrecision")
    Integer lengthOrPrecision;
    @Expose
    @SerializedName(value="Scale")
    Integer scale;
    @Expose
    @SerializedName(value="Record")
    RecordType recordType;
    @Expose
    @SerializedName(value="Map")
    MapType mapType;

    public DataTypeExpr(String typeName) {
        super(OpType.DataType);
        this.typeName = typeName;
    }

    public DataTypeExpr(RecordType record) {
        super(OpType.DataType);
        this.typeName = TajoDataTypes.Type.RECORD.name();
        this.recordType = record;
    }

    public DataTypeExpr(MapType map) {
        super(OpType.DataType);
        this.typeName = TajoDataTypes.Type.MAP.name();
        this.mapType = map;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isPrimitiveType() {
        return !this.isRecordType() && !this.isMapType();
    }

    public boolean isRecordType() {
        return this.typeName.equals(TajoDataTypes.Type.RECORD.name());
    }

    public boolean isMapType() {
        return this.typeName.equals(TajoDataTypes.Type.MAP.name());
    }

    public ColumnDefinition[] getNestedRecordTypes() {
        return this.recordType.schema;
    }

    public boolean hasLengthOrPrecision() {
        return this.lengthOrPrecision != null;
    }

    public void setLengthOrPrecision(int lengthOrPrecision) {
        this.lengthOrPrecision = lengthOrPrecision;
    }

    public Integer getLengthOrPrecision() {
        return this.lengthOrPrecision;
    }

    public boolean hasScale() {
        return this.scale != null;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public Integer getScale() {
        return this.scale;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.typeName, this.lengthOrPrecision, this.scale, this.recordType, this.mapType});
    }

    @Override
    boolean equalsTo(Expr expr) {
        DataTypeExpr another = (DataTypeExpr)expr;
        return this.typeName.equals(another.typeName) && TUtil.checkEquals((Object)this.lengthOrPrecision, (Object)another.lengthOrPrecision) && TUtil.checkEquals((Object)this.scale, (Object)another.scale) && TUtil.checkEquals((Object)this.recordType, (Object)another.recordType) && TUtil.checkEquals((Object)this.mapType, (Object)another.mapType);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataTypeExpr dataType = (DataTypeExpr)super.clone();
        dataType.typeName = this.typeName;
        dataType.lengthOrPrecision = this.lengthOrPrecision;
        dataType.scale = this.scale;
        dataType.recordType = this.recordType;
        dataType.mapType = this.mapType;
        return dataType;
    }

    public static class MapType
    implements JsonSerializable,
    Cloneable {
        @Expose
        @SerializedName(value="KeyType")
        DataTypeExpr keyType;
        @Expose
        @SerializedName(value="ValueType")
        DataTypeExpr valueType;

        public MapType(DataTypeExpr key, DataTypeExpr value) {
            this.keyType = key;
            this.valueType = value;
        }

        @Override
        public String toJson() {
            return JsonHelper.toJson(this);
        }

        public Object clone() throws CloneNotSupportedException {
            MapType newMap = (MapType)super.clone();
            newMap.keyType = this.keyType;
            newMap.valueType = this.valueType;
            return newMap;
        }
    }

    public static class RecordType
    implements JsonSerializable,
    Cloneable {
        @Expose
        @SerializedName(value="Schema")
        ColumnDefinition[] schema;

        public RecordType(ColumnDefinition[] schema) {
            this.schema = schema;
        }

        @Override
        public String toJson() {
            return JsonHelper.toJson(this);
        }

        public Object clone() throws CloneNotSupportedException {
            RecordType newRecord = (RecordType)super.clone();
            newRecord.schema = this.schema;
            return newRecord;
        }
    }
}

