/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.DateValue;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;

public class DateLiteral
extends Expr {
    @Expose
    @SerializedName(value="Date")
    private DateValue date;

    public DateLiteral(DateValue date) {
        super(OpType.DateLiteral);
        this.date = date;
    }

    public DateValue getDate() {
        return this.date;
    }

    @Override
    public String toString() {
        return this.date.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.date});
    }

    @Override
    boolean equalsTo(Expr expr) {
        if (expr instanceof DateLiteral) {
            DateLiteral another = (DateLiteral)expr;
            return this.date.equals(another.date);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DateLiteral newDate = (DateLiteral)super.clone();
        newDate.date = this.date;
        return newDate;
    }
}

