/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;

public class DropTable
extends Expr {
    @Expose
    @SerializedName(value="TableName")
    private String tableName;
    @Expose
    @SerializedName(value="IfExists")
    private boolean ifExists;
    @Expose
    @SerializedName(value="IsPurge")
    private boolean purge;

    public DropTable(String tableName, boolean ifExists, boolean purge) {
        super(OpType.DropTable);
        this.tableName = tableName;
        this.ifExists = ifExists;
        this.purge = purge;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public boolean isPurge() {
        return this.purge;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tableName, this.ifExists, this.purge});
    }

    @Override
    boolean equalsTo(Expr expr) {
        if (expr instanceof DropTable) {
            DropTable another = (DropTable)expr;
            return this.tableName.equals(another.tableName) && this.ifExists == another.ifExists && this.purge == another.purge;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DropTable drop = (DropTable)super.clone();
        drop.tableName = this.tableName;
        drop.ifExists = this.ifExists;
        drop.purge = this.purge;
        return drop;
    }
}

