/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import org.apache.tajo.algebra.BinaryOperator;
import org.apache.tajo.algebra.ExprVisitor;
import org.apache.tajo.algebra.JsonHelper;
import org.apache.tajo.algebra.JsonSerializable;
import org.apache.tajo.algebra.LiteralValue;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.UnaryOperator;
import org.apache.tajo.json.CommonGsonHelper;

public abstract class Expr
implements JsonSerializable,
Cloneable {
    @Expose
    @SerializedName(value="type")
    private static final String SERIALIZED_NAME_OF_OP_TYPE = "OpType";
    @Expose
    @SerializedName(value="OpType")
    protected OpType opType;

    public Expr(OpType opType) {
        this.opType = opType;
    }

    public OpType getType() {
        return this.opType;
    }

    public abstract int hashCode();

    abstract boolean equalsTo(Expr var1);

    public boolean equals(Object obj) {
        if (obj instanceof Expr) {
            Expr casted = (Expr)obj;
            if (this.opType == casted.opType && this.equalsTo(casted)) {
                if (this instanceof UnaryOperator) {
                    UnaryOperator one = (UnaryOperator)this;
                    UnaryOperator another = (UnaryOperator)casted;
                    return one.getChild().equals(another.getChild());
                }
                if (this instanceof BinaryOperator) {
                    BinaryOperator bin = (BinaryOperator)this;
                    BinaryOperator anotherBin = (BinaryOperator)casted;
                    if (!((Expr)bin.getLeft()).equals(anotherBin.getLeft())) {
                        return false;
                    }
                    return ((Expr)bin.getRight()).equals(anotherBin.getRight());
                }
                return this.equalsTo(casted);
            }
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Expr newExpr = (Expr)super.clone();
        newExpr.opType = this.opType;
        return newExpr;
    }

    public String toString() {
        return this.toJson();
    }

    @Override
    public String toJson() {
        return JsonHelper.toJson(this);
    }

    public void accept(ExprVisitor visitor) {
        if (this instanceof UnaryOperator) {
            UnaryOperator unary = (UnaryOperator)this;
            unary.getChild().accept(visitor);
        } else if (this instanceof BinaryOperator) {
            BinaryOperator bin = (BinaryOperator)this;
            ((Expr)bin.getLeft()).accept(visitor);
            ((Expr)bin.getRight()).accept(visitor);
        }
        visitor.visit(this);
    }

    static class JsonSerDer
    implements JsonSerializer<Expr>,
    JsonDeserializer<Expr> {
        JsonSerDer() {
        }

        public Expr deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            String opType = CommonGsonHelper.getOrDie((JsonObject)jsonObject, (String)Expr.SERIALIZED_NAME_OF_OP_TYPE).getAsString();
            if (OpType.valueOf(opType).equals((Object)OpType.Literal)) {
                String value = CommonGsonHelper.getOrDie((JsonObject)jsonObject, (String)"Value").getAsString();
                JsonElement valueTypeElem = jsonObject.get("ValueType");
                if (valueTypeElem != null) {
                    return new LiteralValue(value, LiteralValue.LiteralType.valueOf(valueTypeElem.getAsString()));
                }
                return new LiteralValue(value, LiteralValue.getLiteralType(value));
            }
            return (Expr)context.deserialize(json, (Type)OpType.valueOf(opType).getBaseClass());
        }

        public JsonElement serialize(Expr src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src, (Type)src.opType.getBaseClass());
        }
    }
}

