/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.util.TUtil;

public class FunctionExpr
extends Expr {
    @Expose
    @SerializedName(value="Signature")
    private String signature;
    @Expose
    @SerializedName(value="FuncParams")
    private Expr[] params;

    public FunctionExpr(String signature) {
        this(OpType.Function, signature);
    }

    public FunctionExpr(String signature, Expr[] params) {
        this(OpType.Function, signature);
        this.setParams(params);
    }

    protected FunctionExpr(OpType type, String signature) {
        super(type);
        if (type != OpType.Function && type != OpType.CountRowsFunction) {
            throw new IllegalArgumentException("FunctionExpr cannot accept " + (Object)((Object)type) + "type");
        }
        this.signature = signature.toLowerCase();
    }

    protected FunctionExpr(OpType type, String signature, Expr[] params) {
        super(type);
        if (!OpType.isFunction(type)) {
            throw new IllegalArgumentException("FunctionExpr cannot accept " + (Object)((Object)type) + "type");
        }
        this.signature = signature.toLowerCase();
        this.setParams(params);
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean hasParams() {
        return this.params != null;
    }

    public Expr[] getParams() {
        return this.params;
    }

    public void setParams(Expr[] params) {
        this.params = params;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.signature, Objects.hashCode((Object[])this.params)});
    }

    @Override
    boolean equalsTo(Expr expr) {
        FunctionExpr another = (FunctionExpr)expr;
        return this.signature.equals(another.signature) && TUtil.checkEquals((Object[])this.params, (Object[])another.params);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FunctionExpr func = (FunctionExpr)super.clone();
        func.signature = this.signature;
        if (this.params != null) {
            func.params = new Expr[this.params.length];
            for (int i = 0; i < this.params.length; ++i) {
                func.params[i] = (Expr)this.params[i].clone();
            }
        }
        return func;
    }
}

