/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.util.TUtil;

public class Insert
extends Expr {
    @Expose
    @SerializedName(value="IsOverwrite")
    private boolean overwrite = false;
    @Expose
    @SerializedName(value="TableName")
    private String tableName;
    @Expose
    @SerializedName(value="TargetColumns")
    private ColumnReferenceExpr[] targetColumns;
    @Expose
    @SerializedName(value="StorageType")
    private String storageType;
    @Expose
    @SerializedName(value="Location")
    private String location;
    @Expose
    @SerializedName(value="SubPlan")
    private Expr subquery;
    @Expose
    @SerializedName(value="Properties")
    private Map<String, String> params;

    public Insert() {
        super(OpType.Insert);
    }

    public void setOverwrite() {
        this.overwrite = true;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean hasTableName() {
        return this.tableName != null;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasTargetColumns() {
        return this.targetColumns != null;
    }

    public ColumnReferenceExpr[] getTargetColumns() {
        return this.targetColumns;
    }

    public void setTargetColumns(ColumnReferenceExpr[] targets) {
        this.targetColumns = targets;
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean hasStorageType() {
        return this.storageType != null;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getDataFormat() {
        return this.storageType;
    }

    public boolean hasParams() {
        return this.params != null;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void setSubQuery(Expr subquery) {
        this.subquery = subquery;
    }

    public Expr getSubQuery() {
        return this.subquery;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.overwrite, this.tableName, Objects.hashCode((Object[])this.targetColumns), this.subquery, this.storageType, this.location, this.params});
    }

    @Override
    boolean equalsTo(Expr expr) {
        Insert another = (Insert)expr;
        return this.overwrite == another.overwrite && TUtil.checkEquals((Object)this.tableName, (Object)another.tableName) && TUtil.checkEquals((Object[])this.targetColumns, (Object[])another.targetColumns) && TUtil.checkEquals((Object)this.subquery, (Object)another.subquery) && TUtil.checkEquals((Object)this.storageType, (Object)another.storageType) && TUtil.checkEquals((Object)this.location, (Object)another.location) && TUtil.checkEquals(this.params, another.params);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Insert insert = (Insert)super.clone();
        insert.overwrite = this.overwrite;
        insert.tableName = this.tableName;
        insert.targetColumns = this.targetColumns != null ? (ColumnReferenceExpr[])this.targetColumns.clone() : null;
        insert.storageType = this.storageType;
        insert.location = this.location;
        insert.subquery = (Expr)this.subquery.clone();
        if (this.params != null) {
            insert.params = new HashMap<String, String>(this.params);
        }
        return insert;
    }
}

