/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.BinaryOperator;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.JoinType;
import org.apache.tajo.algebra.JsonHelper;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.util.TUtil;

public class Join
extends BinaryOperator {
    @Expose
    @SerializedName(value="JoinType")
    private JoinType joinType;
    @Expose
    @SerializedName(value="JoinCondition")
    private Expr joinQual;
    @Expose
    @SerializedName(value="JoinColumns")
    private ColumnReferenceExpr[] joinColumns;
    @Expose
    @SerializedName(value="IsNatural")
    private boolean natural = false;

    public Join(JoinType joinType) {
        super(OpType.Join);
        this.joinType = joinType;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public boolean hasQual() {
        return this.joinQual != null;
    }

    public Expr getQual() {
        return this.joinQual;
    }

    public void setQual(Expr expr) {
        this.joinQual = expr;
    }

    public boolean hasJoinColumns() {
        return this.joinColumns != null;
    }

    public ColumnReferenceExpr[] getJoinColumns() {
        return this.joinColumns;
    }

    public void setJoinColumns(ColumnReferenceExpr[] columns) {
        this.joinColumns = columns;
    }

    public void setNatural() {
        this.natural = true;
    }

    public boolean isNatural() {
        return this.natural;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.joinType, this.joinQual, Objects.hashCode((Object[])this.joinColumns), this.natural});
    }

    @Override
    boolean equalsTo(Expr expr) {
        Join another = (Join)expr;
        return this.joinType.equals((Object)another.joinType) && TUtil.checkEquals((Object)this.joinQual, (Object)another.joinQual) && TUtil.checkEquals((Object[])this.joinColumns, (Object[])another.joinColumns) && this.natural == another.natural;
    }

    @Override
    public String toJson() {
        return JsonHelper.toJson(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Join join = (Join)super.clone();
        join.joinType = this.joinType;
        if (this.joinQual != null) {
            join.joinQual = (Expr)this.joinQual.clone();
        }
        if (this.joinColumns != null) {
            join.joinColumns = new ColumnReferenceExpr[this.joinColumns.length];
            for (ColumnReferenceExpr colume : this.joinColumns) {
                join.joinColumns = (ColumnReferenceExpr[])colume.clone();
            }
        }
        join.natural = this.natural;
        return join;
    }
}

