/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.tajo.algebra.CreateTable;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;

public class JsonHelper {
    private static JsonHelper instance = new JsonHelper();
    private GsonBuilder builder;
    private Gson gson;

    private JsonHelper() {
        this.initBuilder();
        this.gson = this.builder.create();
    }

    private void initBuilder() {
        this.builder = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation();
        this.builder.registerTypeAdapter(OpType.class, (Object)new OpType.JsonSerDer());
        this.builder.registerTypeAdapter(Expr.class, (Object)new Expr.JsonSerDer());
        this.builder.registerTypeAdapter(CreateTable.PartitionMethodDescExpr.class, (Object)new CreateTable.PartitionMethodDescExpr.JsonSerDer());
    }

    public static Gson getInstance() {
        return JsonHelper.instance.gson;
    }

    public static String toJson(Object obj) {
        return JsonHelper.instance.gson.toJson(obj);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)JsonHelper.instance.gson.fromJson(json, clazz);
    }
}

