/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;

public class LiteralValue
extends Expr {
    @Expose
    @SerializedName(value="Value")
    protected String value;
    @Expose
    @SerializedName(value="ValueType")
    protected LiteralType valueType;

    public LiteralValue(String value, LiteralType valueType) {
        super(OpType.Literal);
        this.value = value;
        this.valueType = valueType;
    }

    public LiteralType getValueType() {
        return this.valueType;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.valueType, this.value});
    }

    @Override
    public boolean equalsTo(Expr expr) {
        LiteralValue another = (LiteralValue)expr;
        boolean a = this.valueType.equals((Object)another.valueType);
        boolean b = this.value.equals(another.value);
        return a && b;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.valueType == LiteralType.String ? "'" + this.value + "'" : this.value);
        sb.append("(").append((Object)this.valueType).append(")");
        return sb.toString();
    }

    public static LiteralType getLiteralType(String value) {
        if (value.equals("TRUE") || value.equals("FALSE")) {
            return LiteralType.Boolean;
        }
        try {
            Long.parseLong(value);
            return LiteralType.Unsigned_Integer;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(value);
                return LiteralType.Unsigned_Float;
            }
            catch (NumberFormatException numberFormatException2) {
                return LiteralType.String;
            }
        }
    }

    @Override
    public LiteralValue clone() throws CloneNotSupportedException {
        LiteralValue literal = (LiteralValue)super.clone();
        literal.valueType = this.valueType;
        literal.value = this.value;
        return literal;
    }

    public static enum LiteralType {
        Boolean,
        String,
        Unsigned_Integer,
        Unsigned_Float,
        Unsigned_Large_Integer;

    }
}

