/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.JsonHelper;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.UnaryOperator;
import org.apache.tajo.util.TUtil;

public class NamedExpr
extends UnaryOperator {
    @Expose
    @SerializedName(value="AliasName")
    private String alias;

    public NamedExpr(Expr expr) {
        super(OpType.Target);
        this.setChild(expr);
    }

    public NamedExpr(Expr expr, String alias) {
        this(expr);
        this.setAlias(alias);
    }

    public Expr getExpr() {
        return this.getChild();
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alias, this.getChild()});
    }

    @Override
    public boolean equalsTo(Expr obj) {
        if (obj instanceof NamedExpr) {
            NamedExpr another = (NamedExpr)obj;
            return TUtil.checkEquals((Object)this.alias, (Object)another.alias);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getChild().toString() + (this.hasAlias() ? " AS " + this.alias : "");
    }

    @Override
    public String toJson() {
        return JsonHelper.toJson(this);
    }

    @Override
    public NamedExpr clone() throws CloneNotSupportedException {
        NamedExpr namedExpr = (NamedExpr)super.clone();
        namedExpr.alias = this.alias;
        return namedExpr;
    }
}

