/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.tajo.algebra.Aggregation;
import org.apache.tajo.algebra.AlterTable;
import org.apache.tajo.algebra.AlterTablespace;
import org.apache.tajo.algebra.BetweenPredicate;
import org.apache.tajo.algebra.BinaryOperator;
import org.apache.tajo.algebra.CaseWhenPredicate;
import org.apache.tajo.algebra.CastExpr;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.CountRowsFunctionExpr;
import org.apache.tajo.algebra.CreateDatabase;
import org.apache.tajo.algebra.CreateIndex;
import org.apache.tajo.algebra.CreateTable;
import org.apache.tajo.algebra.DataTypeExpr;
import org.apache.tajo.algebra.DateLiteral;
import org.apache.tajo.algebra.DropDatabase;
import org.apache.tajo.algebra.DropIndex;
import org.apache.tajo.algebra.DropTable;
import org.apache.tajo.algebra.ExistsPredicate;
import org.apache.tajo.algebra.Explain;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.FunctionExpr;
import org.apache.tajo.algebra.GeneralSetFunctionExpr;
import org.apache.tajo.algebra.Having;
import org.apache.tajo.algebra.InPredicate;
import org.apache.tajo.algebra.Insert;
import org.apache.tajo.algebra.IntervalLiteral;
import org.apache.tajo.algebra.IsNullPredicate;
import org.apache.tajo.algebra.Join;
import org.apache.tajo.algebra.Limit;
import org.apache.tajo.algebra.LiteralValue;
import org.apache.tajo.algebra.NamedExpr;
import org.apache.tajo.algebra.NotExpr;
import org.apache.tajo.algebra.NullLiteral;
import org.apache.tajo.algebra.PatternMatchPredicate;
import org.apache.tajo.algebra.Projection;
import org.apache.tajo.algebra.QualifiedAsteriskExpr;
import org.apache.tajo.algebra.Relation;
import org.apache.tajo.algebra.RelationList;
import org.apache.tajo.algebra.ScalarSubQuery;
import org.apache.tajo.algebra.Selection;
import org.apache.tajo.algebra.SetOperation;
import org.apache.tajo.algebra.SetSession;
import org.apache.tajo.algebra.SignedExpr;
import org.apache.tajo.algebra.SimpleTableSubquery;
import org.apache.tajo.algebra.Sort;
import org.apache.tajo.algebra.TablePrimarySubQuery;
import org.apache.tajo.algebra.TimeLiteral;
import org.apache.tajo.algebra.TimestampLiteral;
import org.apache.tajo.algebra.TruncateTable;
import org.apache.tajo.algebra.ValueListExpr;
import org.apache.tajo.algebra.Window;
import org.apache.tajo.algebra.WindowFunctionExpr;

public enum OpType {
    SetSession(SetSession.class),
    Projection(Projection.class),
    Limit(Limit.class),
    Sort(Sort.class),
    Having(Having.class),
    Aggregation(Aggregation.class),
    Join(Join.class),
    Filter(Selection.class),
    Union(SetOperation.class),
    Except(SetOperation.class),
    Intersect(SetOperation.class),
    TablePrimaryTableSubQuery(TablePrimarySubQuery.class),
    SimpleTableSubquery(SimpleTableSubquery.class),
    RelationList(RelationList.class),
    Relation(Relation.class),
    ScalarSubQuery(ScalarSubQuery.class),
    Explain(Explain.class),
    Window(Window.class),
    CreateDatabase(CreateDatabase.class),
    DropDatabase(DropDatabase.class),
    CreateTable(CreateTable.class),
    DropTable(DropTable.class),
    AlterTablespace(AlterTablespace.class),
    AlterTable(AlterTable.class),
    CreateIndex(CreateIndex.class),
    DropIndex(DropIndex.class),
    TruncateTable(TruncateTable.class),
    Insert(Insert.class),
    And(BinaryOperator.class),
    Or(BinaryOperator.class),
    Not(NotExpr.class),
    Equals(BinaryOperator.class),
    NotEquals(BinaryOperator.class),
    LessThan(BinaryOperator.class),
    LessThanOrEquals(BinaryOperator.class),
    GreaterThan(BinaryOperator.class),
    GreaterThanOrEquals(BinaryOperator.class),
    Between(BetweenPredicate.class),
    CaseWhen(CaseWhenPredicate.class),
    IsNullPredicate(IsNullPredicate.class),
    InPredicate(InPredicate.class),
    ValueList(ValueListExpr.class),
    ExistsPredicate(ExistsPredicate.class),
    LikePredicate(PatternMatchPredicate.class),
    SimilarToPredicate(PatternMatchPredicate.class),
    Regexp(PatternMatchPredicate.class),
    Concatenate(BinaryOperator.class),
    Plus(BinaryOperator.class),
    Minus(BinaryOperator.class),
    Multiply(BinaryOperator.class),
    Divide(BinaryOperator.class),
    Modular(BinaryOperator.class),
    Sign(SignedExpr.class),
    Column(ColumnReferenceExpr.class),
    Target(NamedExpr.class),
    Function(FunctionExpr.class),
    Asterisk(QualifiedAsteriskExpr.class),
    WindowFunction(WindowFunctionExpr.class),
    CountRowsFunction(CountRowsFunctionExpr.class),
    GeneralSetFunction(GeneralSetFunctionExpr.class),
    DataType(DataTypeExpr.class),
    Cast(CastExpr.class),
    Literal(LiteralValue.class),
    NullLiteral(NullLiteral.class),
    TimeLiteral(TimeLiteral.class),
    DateLiteral(DateLiteral.class),
    TimestampLiteral(TimestampLiteral.class),
    IntervalLiteral(IntervalLiteral.class);

    private Class baseClass;

    private OpType() {
        this.baseClass = Expr.class;
    }

    private OpType(Class clazz) {
        this.baseClass = clazz;
    }

    public Class getBaseClass() {
        return this.baseClass;
    }

    public static boolean isLogicalType(OpType type) {
        return type == Not || type == And || type == Or;
    }

    public static boolean isComparisonType(OpType type) {
        return type == Equals || type == NotEquals || type == LessThan || type == GreaterThan || type == LessThanOrEquals || type == GreaterThanOrEquals;
    }

    public static boolean isArithmeticType(OpType type) {
        return type == Plus || type == Minus || type == Multiply || type == Divide || type == Modular;
    }

    public static boolean isLiteralType(OpType type) {
        return type == Literal || type == NullLiteral || type == TimeLiteral || type == DateLiteral || type == TimestampLiteral;
    }

    public static boolean isFunction(OpType type) {
        return type == Function || OpType.isAggregationFunction(type) || OpType.isWindowFunction(type);
    }

    public static boolean isAggregationFunction(OpType type) {
        return type == GeneralSetFunction || type == CountRowsFunction;
    }

    public static boolean isWindowFunction(OpType type) {
        return type == WindowFunction;
    }

    public static class JsonSerDer
    implements JsonSerializer<OpType>,
    JsonDeserializer<OpType> {
        public JsonElement serialize(OpType src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.name());
        }

        public OpType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return OpType.valueOf(json.getAsString());
        }
    }
}

