/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.BinaryOperator;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;

public class PatternMatchPredicate
extends BinaryOperator {
    @Expose
    @SerializedName(value="IsNot")
    private boolean not;
    @Expose
    @SerializedName(value="IsCaseInsensitive")
    private boolean caseInsensitive;

    public PatternMatchPredicate(OpType opType, boolean not, Expr predicand, Expr pattern, boolean caseInsensitive) {
        super(opType);
        Preconditions.checkArgument((opType == OpType.LikePredicate || opType == OpType.SimilarToPredicate || opType == OpType.Regexp ? 1 : 0) != 0, (Object)("pattern matching predicate is only available: " + opType.name()));
        this.not = not;
        this.caseInsensitive = caseInsensitive;
        this.setLeft(predicand);
        this.setRight(pattern);
    }

    public PatternMatchPredicate(OpType opType, boolean not, Expr predicand, Expr pattern) {
        this(opType, not, predicand, pattern, false);
    }

    public boolean isNot() {
        return this.not;
    }

    public Expr getPredicand() {
        return this.getLeft();
    }

    public Expr getPattern() {
        return this.getRight();
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    boolean equalsTo(Expr expr) {
        PatternMatchPredicate another = (PatternMatchPredicate)expr;
        return this.opType == another.opType && this.not == another.not && this.caseInsensitive == another.caseInsensitive;
    }

    @Override
    public PatternMatchPredicate clone() throws CloneNotSupportedException {
        PatternMatchPredicate patternMatchPredicate = (PatternMatchPredicate)super.clone();
        patternMatchPredicate.not = this.not;
        patternMatchPredicate.caseInsensitive = this.caseInsensitive;
        return patternMatchPredicate;
    }
}

