/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.JsonHelper;
import org.apache.tajo.algebra.NamedExpr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.UnaryOperator;
import org.apache.tajo.util.TUtil;

public class Projection
extends UnaryOperator
implements Cloneable {
    @Expose
    @SerializedName(value="IsDistinct")
    private boolean distinct = false;
    @Expose
    @SerializedName(value="Projections")
    private NamedExpr[] targets;

    public Projection() {
        super(OpType.Projection);
    }

    public int size() {
        return this.targets.length;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct() {
        this.distinct = true;
    }

    public NamedExpr[] getNamedExprs() {
        return this.targets;
    }

    public void setNamedExprs(NamedExpr[] targets) {
        this.targets = targets;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.distinct, Objects.hashCode((Object[])this.targets), this.getChild()});
    }

    @Override
    boolean equalsTo(Expr expr) {
        Projection another = (Projection)expr;
        return this.distinct == another.distinct && TUtil.checkEquals((Object[])this.targets, (Object[])another.targets);
    }

    @Override
    public String toJson() {
        return JsonHelper.toJson(this);
    }

    @Override
    public Projection clone() throws CloneNotSupportedException {
        Projection projection = (Projection)super.clone();
        projection.distinct = this.distinct;
        if (this.targets != null) {
            projection.targets = new NamedExpr[this.targets.length];
            for (int i = 0; i < this.targets.length; ++i) {
                projection.targets[i] = this.targets[i].clone();
            }
        }
        return projection;
    }
}

