/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.util.TUtil;

public class QualifiedAsteriskExpr
extends Expr {
    private static final String ASTERISK = "*";
    @Expose
    @SerializedName(value="Qualifier")
    private String qualifier;

    public QualifiedAsteriskExpr() {
        super(OpType.Asterisk);
    }

    public QualifiedAsteriskExpr(String qualifier) {
        this();
        this.setQualifier(qualifier);
    }

    public boolean hasQualifier() {
        return this.qualifier != null;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.qualifier, ASTERISK});
    }

    @Override
    boolean equalsTo(Expr expr) {
        QualifiedAsteriskExpr another = (QualifiedAsteriskExpr)expr;
        return TUtil.checkEquals((Object)this.qualifier, (Object)another.qualifier);
    }

    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public String toString() {
        return this.hasQualifier() ? this.qualifier + "." + ASTERISK : ASTERISK;
    }

    @Override
    public QualifiedAsteriskExpr clone() throws CloneNotSupportedException {
        QualifiedAsteriskExpr qualifiedAsteriskExpr = (QualifiedAsteriskExpr)super.clone();
        qualifiedAsteriskExpr.qualifier = this.qualifier;
        return qualifiedAsteriskExpr;
    }
}

