/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.JsonHelper;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.util.TUtil;

public class Relation
extends Expr {
    @Expose
    @SerializedName(value="TableName")
    protected String tableName;
    @Expose
    @SerializedName(value="TableAlias")
    protected String alias;

    protected Relation(OpType type, String relationName) {
        super(type);
        this.tableName = relationName;
    }

    public Relation(String relationName) {
        this(OpType.Relation, relationName);
    }

    public String getCanonicalName() {
        return this.alias == null ? this.tableName : this.alias;
    }

    public String getName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String toJson() {
        return JsonHelper.toJson(this);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tableName, this.alias});
    }

    @Override
    boolean equalsTo(Expr expr) {
        Relation other = (Relation)expr;
        return TUtil.checkEquals((Object)this.tableName, (Object)other.tableName) && TUtil.checkEquals((Object)this.alias, (Object)other.alias);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Relation relation = (Relation)super.clone();
        relation.tableName = this.tableName;
        relation.alias = this.alias;
        return relation;
    }
}

