/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.Set;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.util.TUtil;

public class RelationList
extends Expr {
    @Expose
    @SerializedName(value="Relations")
    private Expr[] relations;

    public RelationList(Expr[] relations) {
        super(OpType.RelationList);
        this.checkRelations(relations);
        this.relations = relations;
    }

    private void checkRelations(Expr[] relations) {
        for (Expr rel : relations) {
            Preconditions.checkArgument((rel.getType() == OpType.Relation || rel.getType() == OpType.Join || rel.getType() == OpType.TablePrimaryTableSubQuery || rel.getType() == OpType.SimpleTableSubquery ? 1 : 0) != 0, (Object)("Only Relation, Join, or TablePrimarySubQuery can be given to RelationList, but this expr  is " + (Object)((Object)rel.getType())));
        }
    }

    public Expr[] getRelations() {
        return this.relations;
    }

    public int size() {
        return this.relations.length;
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])this.relations);
    }

    @Override
    boolean equalsTo(Expr expr) {
        Set thisSet = TUtil.newHashSet((Object[])this.relations);
        RelationList another = (RelationList)expr;
        Set anotherSet = TUtil.newHashSet((Object[])another.relations);
        return thisSet.equals(anotherSet);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RelationList relationList = (RelationList)super.clone();
        relationList.relations = new Expr[this.relations.length];
        for (int i = 0; i < this.relations.length; ++i) {
            relationList.relations[i] = (Expr)this.relations[i].clone();
        }
        return relationList;
    }
}

