/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.BinaryOperator;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;

public class SetOperation
extends BinaryOperator {
    @Expose
    @SerializedName(value="IsDistinct")
    private boolean distinct = true;

    public SetOperation(OpType type, Expr left, Expr right, boolean distinct) {
        super(type, left, right);
        Preconditions.checkArgument((type == OpType.Union || type == OpType.Intersect || type == OpType.Except ? 1 : 0) != 0);
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void unsetDistinct() {
        this.distinct = false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.distinct, this.getLeft(), this.getRight()});
    }

    @Override
    boolean equalsTo(Expr expr) {
        SetOperation another = (SetOperation)expr;
        return this.distinct == another.distinct;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SetOperation setOperation = (SetOperation)super.clone();
        setOperation.distinct = this.distinct;
        return setOperation;
    }
}

