/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.JsonHelper;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.UnaryOperator;
import org.apache.tajo.util.TUtil;

public class Sort
extends UnaryOperator {
    @Expose
    @SerializedName(value="SortSpecs")
    private SortSpec[] sortSpecs;

    public Sort(SortSpec[] sortSpecs) {
        super(OpType.Sort);
        this.sortSpecs = sortSpecs;
    }

    public void setSortSpecs(SortSpec[] sortSpecs) {
        this.sortSpecs = sortSpecs;
    }

    public SortSpec[] getSortSpecs() {
        return this.sortSpecs;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])this.sortSpecs);
    }

    @Override
    public boolean equalsTo(Expr expr) {
        Sort another = (Sort)expr;
        return TUtil.checkEquals((Object[])this.sortSpecs, (Object[])another.sortSpecs);
    }

    @Override
    public String toJson() {
        return JsonHelper.toJson(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Sort sort = (Sort)super.clone();
        sort.sortSpecs = new SortSpec[this.sortSpecs.length];
        for (int i = 0; i < this.sortSpecs.length; ++i) {
            sort.sortSpecs[i] = (SortSpec)this.sortSpecs[i].clone();
        }
        return sort;
    }

    public static class SortSpec
    implements Cloneable {
        @Expose
        @SerializedName(value="SortKey")
        private Expr key;
        @Expose
        @SerializedName(value="IsAsc")
        private boolean asc = true;
        @Expose
        @SerializedName(value="IsNullsFirst")
        private Boolean nullsFirst = null;

        public SortSpec(Expr key) {
            this.key = key;
        }

        public SortSpec(ColumnReferenceExpr sortKey, boolean asc, boolean nullsFirst) {
            this(sortKey);
            this.asc = asc;
            this.nullsFirst = nullsFirst;
        }

        public final boolean isAscending() {
            return this.asc;
        }

        public final void setDescending() {
            this.asc = false;
        }

        public final boolean isNullsFirst() {
            if (this.nullsFirst == null) {
                return !this.asc;
            }
            return this.nullsFirst;
        }

        public final void setNullsFirst() {
            this.nullsFirst = true;
        }

        public final void setNullsLast() {
            this.nullsFirst = false;
        }

        public void setKey(Expr expr) {
            this.key = expr;
        }

        public final Expr getKey() {
            return this.key;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.asc, this.key, this.nullsFirst});
        }

        public boolean equals(Object obj) {
            if (obj instanceof SortSpec) {
                SortSpec other = (SortSpec)obj;
                return TUtil.checkEquals((Object)this.key, (Object)other.key) && TUtil.checkEquals((Object)this.asc, (Object)other.asc) && TUtil.checkEquals((Object)this.nullsFirst, (Object)other.nullsFirst);
            }
            return false;
        }

        public String toString() {
            return this.key + " " + (this.asc ? "asc" : "desc") + " " + (this.isNullsFirst() ? "nulls first" : "nulls last");
        }

        public Object clone() throws CloneNotSupportedException {
            SortSpec sortSpec = (SortSpec)super.clone();
            sortSpec.key = (Expr)this.key.clone();
            sortSpec.asc = this.asc;
            sortSpec.nullsFirst = this.nullsFirst;
            return sortSpec;
        }
    }
}

