/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang.StringUtils;

public class TimeValue
implements Cloneable {
    @Expose
    @SerializedName(value="Hour")
    private String hours;
    @Expose
    @SerializedName(value="Minute")
    private String minutes;
    @Expose
    @SerializedName(value="Second")
    private String seconds;
    @Expose
    @SerializedName(value="SecondFrac")
    private String secondsFraction;

    public TimeValue(String hours, String minutes, String seconds) {
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public String getHours() {
        return this.hours;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public String getSeconds() {
        return this.seconds;
    }

    public boolean hasSecondsFraction() {
        return this.secondsFraction != null;
    }

    public void setSecondsFraction(String secondsFraction) {
        this.secondsFraction = StringUtils.rightPad((String)secondsFraction, (int)3, (char)'0');
    }

    public String getSecondsFraction() {
        return this.secondsFraction;
    }

    public boolean equals(Object object) {
        if (object instanceof TimeValue) {
            TimeValue another = (TimeValue)object;
            return this.hours.equals(another.hours) && this.minutes.equals(another.minutes) && this.seconds.equals(another.seconds);
        }
        return false;
    }

    public String toString() {
        if (this.hasSecondsFraction()) {
            return String.format("%s:%s:%s.%s", this.hours, this.minutes, this.seconds, this.secondsFraction);
        }
        return String.format("%s:%s:%s", this.hours, this.minutes, this.seconds);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hours, this.minutes, this.seconds});
    }

    public Object clone() throws CloneNotSupportedException {
        TimeValue timeValue = (TimeValue)super.clone();
        timeValue.hours = this.hours;
        timeValue.minutes = this.minutes;
        timeValue.seconds = this.seconds;
        timeValue.secondsFraction = this.secondsFraction;
        return timeValue;
    }
}

