/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.DateValue;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.TimeValue;

public class TimestampLiteral
extends Expr
implements Cloneable {
    @Expose
    @SerializedName(value="Date")
    private DateValue date;
    @Expose
    @SerializedName(value="Time")
    private TimeValue time;

    public TimestampLiteral(DateValue date, TimeValue time) {
        super(OpType.TimestampLiteral);
        this.date = date;
        this.time = time;
    }

    public DateValue getDate() {
        return this.date;
    }

    public TimeValue getTime() {
        return this.time;
    }

    @Override
    public String toString() {
        return this.date + " " + this.time;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.date, this.time});
    }

    @Override
    boolean equalsTo(Expr expr) {
        if (expr instanceof TimestampLiteral) {
            TimestampLiteral another = (TimestampLiteral)expr;
            return this.date.equals(another.date) && this.time.equals(another.time);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TimestampLiteral timestampLiteral = (TimestampLiteral)super.clone();
        timestampLiteral.date = this.date;
        timestampLiteral.time = this.time;
        return timestampLiteral;
    }
}

