/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.util.TUtil;

public class ValueListExpr
extends Expr {
    @Expose
    @SerializedName(value="Values")
    private Expr[] values;

    public ValueListExpr(Expr[] values) {
        super(OpType.ValueList);
        this.values = values;
    }

    public Expr[] getValues() {
        return this.values;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])this.values);
    }

    @Override
    boolean equalsTo(Expr expr) {
        ValueListExpr valueListExpr = (ValueListExpr)expr;
        return TUtil.checkEquals((Object[])this.values, (Object[])valueListExpr.values);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ValueListExpr valueListExpr = (ValueListExpr)super.clone();
        valueListExpr.values = new Expr[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            valueListExpr.values[i] = (Expr)this.values[i].clone();
        }
        return valueListExpr;
    }
}

