/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.algebra.UnaryOperator;
import org.apache.tajo.algebra.WindowSpec;
import org.apache.tajo.util.TUtil;

public class Window
extends UnaryOperator {
    private WindowDefinition[] definitions;

    public Window(WindowDefinition[] definitions) {
        super(OpType.Window);
        this.definitions = definitions;
    }

    public WindowDefinition[] getWindowDefinitions() {
        return this.definitions;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])this.definitions);
    }

    @Override
    boolean equalsTo(Expr expr) {
        Window another = (Window)expr;
        return TUtil.checkEquals((Object[])this.definitions, (Object[])another.definitions);
    }

    public static class WindowDefinition {
        private String windowName;
        private WindowSpec windowSpec;

        public WindowDefinition(String windowName, WindowSpec spec) {
            this.windowName = windowName;
            this.windowSpec = spec;
        }

        public String getWindowName() {
            return this.windowName;
        }

        public WindowSpec getWindowSpec() {
            return this.windowSpec;
        }
    }
}

