/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.algebra;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.Sort;
import org.apache.tajo.util.TUtil;

public class WindowSpec
implements Cloneable {
    @Expose
    private String windowName;
    @Expose
    private Expr[] partitionKeys;
    @Expose
    private Sort.SortSpec[] sortSpecs;
    @Expose
    private WindowFrame windowFrame;

    public boolean hasWindowName() {
        return this.windowName != null;
    }

    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public boolean hasPartitionBy() {
        return this.partitionKeys != null;
    }

    public void setPartitionKeys(Expr[] partitionKeys) {
        this.partitionKeys = partitionKeys;
    }

    public Expr[] getPartitionKeys() {
        return this.partitionKeys;
    }

    public boolean hasOrderBy() {
        return this.sortSpecs != null;
    }

    public void setSortSpecs(Sort.SortSpec[] sortSpecs) {
        this.sortSpecs = sortSpecs;
    }

    public Sort.SortSpec[] getSortSpecs() {
        return this.sortSpecs;
    }

    public boolean hasWindowFrame() {
        return this.windowFrame != null;
    }

    public void setWindowFrame(WindowFrame frame) {
        this.windowFrame = frame;
    }

    public WindowFrame getWindowFrame() {
        return this.windowFrame;
    }

    public Object clone() throws CloneNotSupportedException {
        int i;
        WindowSpec windowSpec = (WindowSpec)super.clone();
        windowSpec.windowName = this.windowName;
        if (this.hasPartitionBy()) {
            windowSpec.partitionKeys = new Expr[windowSpec.partitionKeys.length];
            for (i = 0; i < this.partitionKeys.length; ++i) {
                windowSpec.partitionKeys[i] = (Expr)this.partitionKeys[i].clone();
            }
        }
        if (this.hasOrderBy()) {
            windowSpec.sortSpecs = new Sort.SortSpec[this.sortSpecs.length];
            for (i = 0; i < this.sortSpecs.length; ++i) {
                windowSpec.sortSpecs[i] = (Sort.SortSpec)this.sortSpecs[i].clone();
            }
        }
        if (this.hasWindowFrame()) {
            windowSpec.windowFrame = (WindowFrame)this.windowFrame.clone();
        }
        return windowSpec;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.windowName, this.partitionKeys, this.sortSpecs});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WindowSpec) {
            WindowSpec another = (WindowSpec)obj;
            return TUtil.checkEquals((Object)this.windowName, (Object)another.windowName) && TUtil.checkEquals((Object[])this.partitionKeys, (Object[])another.partitionKeys) && TUtil.checkEquals((Object[])this.sortSpecs, (Object[])another.sortSpecs) && TUtil.checkEquals((Object)this.windowFrame, (Object)another.windowFrame);
        }
        return false;
    }

    public static class WindowEndBound
    implements Cloneable {
        @Expose
        private WindowFrameEndBoundType boundType;
        @Expose
        private Expr number;

        public WindowEndBound(WindowFrameEndBoundType type) {
            this.boundType = type;
        }

        public WindowFrameEndBoundType getBoundType() {
            return this.boundType;
        }

        public boolean hasNumber() {
            return this.number != null;
        }

        public void setNumber(Expr number) {
            this.number = number;
        }

        public Expr getNumber() {
            return this.number;
        }

        public Object clone() throws CloneNotSupportedException {
            WindowEndBound end = (WindowEndBound)super.clone();
            end.boundType = this.boundType;
            end.number = (Expr)this.number.clone();
            return end;
        }
    }

    public static class WindowStartBound
    implements Cloneable {
        @Expose
        private WindowFrameStartBoundType boundType;
        @Expose
        private Expr number;

        public WindowStartBound(WindowFrameStartBoundType type) {
            this.boundType = type;
        }

        public WindowFrameStartBoundType getBoundType() {
            return this.boundType;
        }

        public boolean hasNumber() {
            return this.number != null;
        }

        public void setNumber(Expr number) {
            this.number = number;
        }

        public Expr getNumber() {
            return this.number;
        }

        public Object clone() throws CloneNotSupportedException {
            WindowStartBound start = (WindowStartBound)super.clone();
            start.boundType = this.boundType;
            start.number = (Expr)this.number.clone();
            return start;
        }
    }

    public static class WindowFrame
    implements Cloneable {
        @Expose
        private WindowFrameUnit unit;
        @Expose
        private WindowStartBound startBound;
        @Expose
        private WindowEndBound endBound;

        public WindowFrame(WindowFrameUnit unit, WindowStartBound startBound) {
            this.unit = unit;
            this.startBound = startBound;
        }

        public WindowFrame(WindowFrameUnit unit, WindowStartBound startBound, WindowEndBound endBound) {
            this(unit, startBound);
            this.endBound = endBound;
        }

        public WindowStartBound getStartBound() {
            return this.startBound;
        }

        public boolean hasEndBound() {
            return this.endBound != null;
        }

        public WindowEndBound getEndBound() {
            return this.endBound;
        }

        public Object clone() throws CloneNotSupportedException {
            WindowFrame frame = (WindowFrame)super.clone();
            frame.unit = this.unit;
            frame.startBound = (WindowStartBound)this.startBound.clone();
            frame.endBound = (WindowEndBound)this.endBound.clone();
            return frame;
        }
    }

    public static enum WindowFrameEndBoundType {
        UNBOUNDED_FOLLOWING,
        CURRENT_ROW,
        FOLLOWING;

    }

    public static enum WindowFrameStartBoundType {
        UNBOUNDED_PRECEDING,
        CURRENT_ROW,
        PRECEDING;

    }

    public static enum WindowFrameUnit {
        ROW,
        RANGE;

    }
}

