/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.client;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.tajo.annotation.Nullable;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.catalog.TableMeta;
import org.apache.tajo.catalog.partition.PartitionMethodDesc;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.client.CatalogAdminClient;
import org.apache.tajo.client.SessionConnection;
import org.apache.tajo.error.Errors;
import org.apache.tajo.exception.CannotDropCurrentDatabaseException;
import org.apache.tajo.exception.DuplicateDatabaseException;
import org.apache.tajo.exception.DuplicateTableException;
import org.apache.tajo.exception.ExceptionUtil;
import org.apache.tajo.exception.InsufficientPrivilegeException;
import org.apache.tajo.exception.ReturnStateUtil;
import org.apache.tajo.exception.UnavailableTableLocationException;
import org.apache.tajo.exception.UndefinedDatabaseException;
import org.apache.tajo.exception.UndefinedPartitionMethodException;
import org.apache.tajo.exception.UndefinedTableException;
import org.apache.tajo.ipc.ClientProtos;
import org.apache.tajo.ipc.TajoMasterClientProtocol;
import org.apache.tajo.rpc.NettyClientBase;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;

public class CatalogAdminClientImpl
implements CatalogAdminClient {
    private final SessionConnection conn;

    public CatalogAdminClientImpl(SessionConnection conn) {
        this.conn = conn;
    }

    @Override
    public void createDatabase(String databaseName) throws DuplicateDatabaseException {
        try {
            TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
            PrimitiveProtos.ReturnState state = stub.createDatabase(null, this.conn.getSessionedString(databaseName));
            ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)state, DuplicateDatabaseException.class);
            ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)state);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean existDatabase(String databaseName) {
        try {
            TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
            PrimitiveProtos.ReturnState state = stub.existDatabase(null, this.conn.getSessionedString(databaseName));
            if (ReturnStateUtil.isThisError((PrimitiveProtos.ReturnState)state, (Errors.ResultCode)Errors.ResultCode.UNDEFINED_DATABASE)) {
                return false;
            }
            ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)state);
            return true;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void dropDatabase(String databaseName) throws UndefinedDatabaseException, InsufficientPrivilegeException, CannotDropCurrentDatabaseException {
        try {
            TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
            PrimitiveProtos.ReturnState state = stub.dropDatabase(null, this.conn.getSessionedString(databaseName));
            ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)state, UndefinedDatabaseException.class);
            ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)state, InsufficientPrivilegeException.class);
            ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)state, CannotDropCurrentDatabaseException.class);
            ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)state);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getAllDatabaseNames() {
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        try {
            return stub.getAllDatabases(null, this.conn.sessionId).getValuesList();
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean existTable(String tableName) {
        PrimitiveProtos.ReturnState state;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        try {
            state = stub.existTable(null, this.conn.getSessionedString(tableName));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        if (ReturnStateUtil.isThisError((PrimitiveProtos.ReturnState)state, (Errors.ResultCode)Errors.ResultCode.UNDEFINED_TABLE)) {
            return false;
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)state);
        return true;
    }

    @Override
    public TableDesc createExternalTable(String tableName, @Nullable Schema schema, URI path, TableMeta meta) throws DuplicateTableException, UnavailableTableLocationException, InsufficientPrivilegeException {
        return this.createExternalTable(tableName, schema, path, meta, null);
    }

    @Override
    public TableDesc createExternalTable(String tableName, @Nullable Schema schema, URI path, TableMeta meta, PartitionMethodDesc partitionMethodDesc) throws DuplicateTableException, InsufficientPrivilegeException, UnavailableTableLocationException {
        CatalogProtos.TableResponse res;
        NettyClientBase client = this.conn.getTajoMasterConnection();
        this.conn.checkSessionAndGet(client);
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface tajoMasterService = (TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface)client.getStub();
        ClientProtos.CreateTableRequest.Builder builder = ClientProtos.CreateTableRequest.newBuilder();
        builder.setSessionId(this.conn.sessionId);
        builder.setName(tableName);
        if (schema != null) {
            builder.setSchema(schema.getProto());
        }
        builder.setMeta(meta.getProto());
        builder.setPath(path.toString());
        if (partitionMethodDesc != null) {
            builder.setPartition(partitionMethodDesc.getProto());
        }
        try {
            res = tajoMasterService.createExternalTable(null, builder.build());
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)res.getState(), DuplicateTableException.class);
        ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)res.getState(), InsufficientPrivilegeException.class);
        ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)res.getState(), UnavailableTableLocationException.class);
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)res.getState());
        return CatalogUtil.newTableDesc((CatalogProtos.TableDescProto)res.getTable());
    }

    @Override
    public void dropTable(String tableName) throws UndefinedTableException, InsufficientPrivilegeException {
        this.dropTable(tableName, false);
    }

    @Override
    public void dropTable(String tableName, boolean purge) throws UndefinedTableException, InsufficientPrivilegeException {
        PrimitiveProtos.ReturnState state;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.DropTableRequest request = ClientProtos.DropTableRequest.newBuilder().setSessionId(this.conn.sessionId).setName(tableName).setPurge(purge).build();
        try {
            state = stub.dropTable(null, request);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)state, UndefinedTableException.class);
        ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)state, InsufficientPrivilegeException.class);
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)state);
    }

    @Override
    public List<String> getTableList(@Nullable String databaseName) {
        PrimitiveProtos.StringListResponse response;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        try {
            response = stub.getTableList(null, this.conn.getSessionedString(databaseName));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)response.getState());
        return response.getValuesList();
    }

    @Override
    public TableDesc getTableDesc(String tableName) throws UndefinedTableException {
        CatalogProtos.TableResponse res;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        try {
            res = stub.getTableDesc(null, this.conn.getSessionedString(tableName));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        if (ReturnStateUtil.isThisError((PrimitiveProtos.ReturnState)res.getState(), (Errors.ResultCode)Errors.ResultCode.UNDEFINED_TABLE)) {
            throw new UndefinedTableException(res.getState());
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)res.getState());
        return CatalogUtil.newTableDesc((CatalogProtos.TableDescProto)res.getTable());
    }

    @Override
    public List<CatalogProtos.PartitionDescProto> getAllPartitions(String tableName) throws UndefinedDatabaseException, UndefinedTableException, UndefinedPartitionMethodException {
        CatalogProtos.PartitionListResponse response;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        try {
            response = stub.getPartitionsByTableName(null, this.conn.getSessionedString(tableName));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)response.getState(), UndefinedDatabaseException.class);
        ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)response.getState(), UndefinedTableException.class);
        ExceptionUtil.throwsIfThisError((PrimitiveProtos.ReturnState)response.getState(), UndefinedPartitionMethodException.class);
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)response.getState());
        return response.getPartitionList();
    }

    @Override
    public List<CatalogProtos.FunctionDescProto> getFunctions(String functionName) {
        CatalogProtos.FunctionListResponse res;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        String paramFunctionName = functionName == null ? "" : functionName;
        try {
            res = stub.getFunctionList(null, this.conn.getSessionedString(paramFunctionName));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)res.getState());
        return res.getFunctionList();
    }

    @Override
    public CatalogProtos.IndexDescProto getIndex(String indexName) {
        CatalogProtos.IndexResponse res;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        try {
            res = stub.getIndexWithName(null, this.conn.getSessionedString(indexName));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)res.getState());
        return res.getIndexDesc();
    }

    @Override
    public boolean existIndex(String indexName) {
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        try {
            return ReturnStateUtil.isSuccess((PrimitiveProtos.ReturnState)stub.existIndexWithName(null, this.conn.getSessionedString(indexName)));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<CatalogProtos.IndexDescProto> getIndexes(String tableName) {
        CatalogProtos.IndexListResponse response;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        try {
            response = stub.getIndexesForTable(null, this.conn.getSessionedString(tableName));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)response.getState());
        return response.getIndexDescList();
    }

    @Override
    public boolean hasIndexes(String tableName) {
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        try {
            return ReturnStateUtil.isSuccess((PrimitiveProtos.ReturnState)stub.existIndexesForTable(null, this.conn.getSessionedString(tableName)));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CatalogProtos.IndexDescProto getIndex(String tableName, String[] columnNames) {
        CatalogProtos.IndexResponse response;
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.GetIndexWithColumnsRequest.Builder builder = ClientProtos.GetIndexWithColumnsRequest.newBuilder();
        builder.setSessionId(this.conn.sessionId);
        builder.setTableName(tableName);
        for (String eachColumnName : columnNames) {
            builder.addColumnNames(eachColumnName);
        }
        try {
            response = stub.getIndexWithColumns(null, builder.build());
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        ReturnStateUtil.ensureOk((PrimitiveProtos.ReturnState)response.getState());
        return response.getIndexDesc();
    }

    @Override
    public boolean existIndex(String tableName, String[] columnName) {
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        ClientProtos.GetIndexWithColumnsRequest.Builder builder = ClientProtos.GetIndexWithColumnsRequest.newBuilder();
        builder.setSessionId(this.conn.sessionId);
        builder.setTableName(tableName);
        for (String eachColumnName : columnName) {
            builder.addColumnNames(eachColumnName);
        }
        try {
            return ReturnStateUtil.isSuccess((PrimitiveProtos.ReturnState)stub.existIndexWithColumns(null, builder.build()));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean dropIndex(String indexName) {
        TajoMasterClientProtocol.TajoMasterClientProtocolService.BlockingInterface stub = this.conn.getTMStub();
        try {
            return ReturnStateUtil.isSuccess((PrimitiveProtos.ReturnState)stub.dropIndex(null, this.conn.getSessionedString(indexName)));
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

