/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.tajo.SessionVars;
import org.apache.tajo.util.Pair;

class ClientParameterHelper {
    public static Map<String, Action> PARAMETERS = new HashMap<String, Action>();

    ClientParameterHelper() {
    }

    public static Properties getConnParams(Collection<Map.Entry<String, String>> properties) {
        Properties connParams = new Properties();
        for (Map.Entry<String, String> entry : properties) {
            if (!PARAMETERS.containsKey(entry.getKey()) || PARAMETERS.get(entry.getKey()).type() != ActionType.CONNECTION_PARAM) continue;
            Pair<String, String> keyValue = ((ConnectionParamAction)PARAMETERS.get(entry.getKey())).doAction(entry.getValue());
            connParams.put(keyValue.getFirst(), keyValue.getSecond());
        }
        return connParams;
    }

    public static Map<String, String> getSessionVars(Collection<Map.Entry<String, String>> properties) {
        HashMap<String, String> sessionVars = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties) {
            if (!PARAMETERS.containsKey(entry.getKey()) || PARAMETERS.get(entry.getKey()).type() != ActionType.SESSION_UPDATE) continue;
            Pair<String, String> keyValue = ((SessionAction)PARAMETERS.get(entry.getKey())).doAction(entry.getValue());
            sessionVars.put((String)keyValue.getFirst(), (String)keyValue.getSecond());
        }
        return sessionVars;
    }

    static {
        PARAMETERS.put("useCompression", new SimpleSessionAction(SessionVars.COMPRESSED_RESULT_TRANSFER));
        PARAMETERS.put("defaultRowFetchSize", new SimpleSessionAction(SessionVars.FETCH_ROWNUM));
        PARAMETERS.put("connectTimeout", new ConnectionParamAction(){

            @Override
            Pair<String, String> doAction(String param) {
                int seconds = Integer.parseInt(param);
                return new Pair((Object)"tajo.rpc.client.connection-timeout-ms", (Object)String.valueOf(TimeUnit.SECONDS.toMillis(seconds)));
            }
        });
        PARAMETERS.put("socketTimeout", new ConnectionParamAction(){

            @Override
            Pair<String, String> doAction(String param) {
                int seconds = Integer.parseInt(param);
                return new Pair((Object)"tajo.rpc.client.socket-timeout-ms", (Object)String.valueOf(TimeUnit.SECONDS.toMillis(seconds)));
            }
        });
        PARAMETERS.put("retry", new SimpleConnectionParamAction("tajo.rpc.client.retry-num"));
    }

    static abstract class ConnectionParamAction
    implements Action {
        ConnectionParamAction() {
        }

        @Override
        public ActionType type() {
            return ActionType.CONNECTION_PARAM;
        }

        abstract Pair<String, String> doAction(String var1);
    }

    static class SimpleConnectionParamAction
    extends ConnectionParamAction {
        final String connParamKey;

        SimpleConnectionParamAction(String connParamKey) {
            this.connParamKey = connParamKey;
        }

        @Override
        public Pair<String, String> doAction(String param) {
            return new Pair((Object)this.connParamKey, (Object)param);
        }
    }

    static abstract class SessionAction
    implements Action {
        SessionAction() {
        }

        @Override
        public ActionType type() {
            return ActionType.SESSION_UPDATE;
        }

        abstract Pair<String, String> doAction(String var1);
    }

    static class SimpleSessionAction
    extends SessionAction {
        private final String sessionKey;

        SimpleSessionAction(SessionVars sessionVar) {
            this.sessionKey = sessionVar.name();
        }

        @Override
        Pair<String, String> doAction(String param) {
            return new Pair((Object)this.sessionKey, (Object)param);
        }
    }

    static interface Action {
        public ActionType type();
    }

    static enum ActionType {
        SESSION_UPDATE,
        CONNECTION_PARAM;

    }
}

